/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.BaseException;
import org.eclipse.vjet.dsf.common.exceptions.BaseRuntimeException;
import org.eclipse.vjet.dsf.common.exceptions.ErrorData;
import org.eclipse.vjet.dsf.common.exceptions.ExceptionUtilities;
import org.eclipse.vjet.dsf.common.exceptions.GenericException;

public final class CommonException
implements Serializable {
    private SuperPrintStackTrace m_actualEbayException;
    private ErrorData m_errorData = null;
    private String m_stringMessage = null;
    private Throwable m_cause = null;
    private String m_foreignStackTrace = null;
    private String m_cachedStackTrace = null;
    private static final long serialVersionUID = 2466318575044764734L;

    public CommonException(SuperPrintStackTrace actualException, String textMessage) {
        this(actualException, textMessage, null);
    }

    public CommonException(SuperPrintStackTrace actualException, String stringMessage, Throwable cause) {
        this.m_actualEbayException = actualException;
        this.m_stringMessage = stringMessage;
        this.m_cause = cause;
    }

    public ErrorData getErrorData() {
        if (this.m_errorData == null) {
            this.m_errorData = new ErrorData(this.getOrigin(), this.m_stringMessage);
        }
        return this.m_errorData;
    }

    public void setErrorData(ErrorData errorData) {
        this.m_errorData = errorData;
    }

    public Throwable getCause() {
        return this.m_cause;
    }

    public void setCause(Throwable cause) {
        this.m_cause = cause;
    }

    public List getErrorDataStack() {
        ArrayList<ErrorData> errorStack = new ArrayList<ErrorData>();
        Throwable cause = (Throwable)((Object)this.m_actualEbayException);
        while (cause != null) {
            if (!(cause instanceof GenericException)) break;
            errorStack.add(((GenericException)((Object)cause)).getErrorData());
            cause = ((GenericException)((Object)cause)).getCause();
        }
        return errorStack;
    }

    public String getMessage() {
        String text = this.getMessageData();
        if (this.m_cause == null) {
            return text;
        }
        String causesMessage = this.m_cause.getMessage();
        return causesMessage == null ? text : String.valueOf(text) + "\n" + causesMessage;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        out.println(this.getCachedStackTrace(null));
    }

    public void printStackTrace(PrintWriter out) {
        out.println(this.getCachedStackTrace(null));
    }

    public void printStackTrace(PrintStream out, Set visited) {
        out.println(this.getCachedStackTrace(visited));
    }

    public void printStackTrace(PrintWriter out, Set visited) {
        out.println(this.getCachedStackTrace(visited));
    }

    private String getMessageData() {
        if (this.m_stringMessage != null) {
            return this.m_stringMessage;
        }
        return null;
    }

    private String getCachedStackTrace(Set visited) {
        if (this.m_cachedStackTrace != null) {
            return this.m_cachedStackTrace;
        }
        String trace = null;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(buf);
        if (this.m_foreignStackTrace == null && this.m_cause != null) {
            if (visited == null) {
                visited = new HashSet<CommonException>();
            }
            visited.add(this);
            if (!visited.contains(this.m_cause)) {
                if (this.m_cause instanceof BaseException) {
                    ((BaseException)this.m_cause).printStackTrace(pout, visited);
                } else if (this.m_cause instanceof BaseRuntimeException) {
                    ((BaseRuntimeException)this.m_cause).printStackTrace(pout, visited);
                } else {
                    ExceptionUtilities.printRecursiveStackTrace(this.m_cause, pout, visited);
                }
            }
        }
        this.m_actualEbayException.superPrintStackTrace(pout);
        pout.flush();
        trace = buf.toString();
        try {
            pout.close();
            pout = null;
            buf.close();
            buf = null;
        }
        catch (IOException iOException) {}
        if (this.m_foreignStackTrace != null) {
            trace = String.valueOf(this.m_foreignStackTrace) + trace;
        }
        this.m_cachedStackTrace = trace;
        this.m_foreignStackTrace = null;
        trace = null;
        return this.m_cachedStackTrace;
    }

    private String getOrigin() {
        return "unknown";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getErrorData());
        if (this.m_foreignStackTrace == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.m_foreignStackTrace);
        }
        String cached = this.getCachedStackTrace(null);
        if (cached == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(cached);
        }
        if (this.m_cause == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.m_cause);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_errorData = (ErrorData)in.readObject();
        this.m_foreignStackTrace = in.readBoolean() ? (String)in.readObject() : null;
        this.m_cachedStackTrace = in.readBoolean() ? (String)in.readObject() : null;
        this.m_cause = in.readBoolean() ? (Throwable)in.readObject() : null;
    }

    public static interface SuperPrintStackTrace {
        public void superPrintStackTrace(PrintStream var1);
    }
}

