/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.enums;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.vjet.dsf.common.enums.BaseEnum;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.dsf.util.JdkUtil;

public class EnumManager {
    private static final int DEFAULT_MAP_SIZE = 19;
    private BaseEnum m_firstEnum = null;
    private BaseEnum m_lastEnum = null;
    private final Map<Integer, BaseEnum> m_map = new HashMap<Integer, BaseEnum>(19);
    private static final ConcurrentMap<Class, EnumManager> s_managers = new ConcurrentHashMap<Class, EnumManager>();
    private static volatile Logger s_logger = null;

    private static Logger getLogger() {
        if (s_logger == null) {
            s_logger = Logger.getInstance(EnumManager.class);
        }
        return s_logger;
    }

    private EnumManager() {
    }

    static void add(BaseEnum enumX) {
        EnumManager.getManager(enumX.getClass()).addToManager(enumX);
    }

    static BaseEnum getEnum(Class type, int id) {
        return EnumManager.getManager(type).get(type, id);
    }

    static BaseEnum getEnum(Class type, String name) {
        return EnumManager.getManager(type).get(type, name);
    }

    static BaseEnum getEnumIgnoreCase(Class type, String name) {
        return EnumManager.getManager(type).getIgnoreCase(type, name);
    }

    static BaseEnum getEnum(Class type, Integer id) {
        if (id == null) {
            return null;
        }
        return EnumManager.getEnum(type, (int)id);
    }

    static BaseEnum getElseEnum(Class type, int id, BaseEnum defaultEnum) {
        return EnumManager.getManager(type).getElseReturn(type, id, defaultEnum);
    }

    static ListIterator getIterator(Class type) {
        return EnumManager.getManager(type).iterator();
    }

    static List getList(Class type) {
        return EnumManager.getManager(type).getList();
    }

    static Object createEnclosedEnumArray(Class clz, Class[] enclosingClzz) {
        if (!BaseEnum.class.isAssignableFrom(clz)) {
            throw new IllegalArgumentException("createEnclosingEnumArray: " + clz + " is not the right type");
        }
        Constructor<?>[] constructors = clz.getDeclaredConstructors();
        int i = 0;
        while (i < constructors.length) {
            int modifier = constructors[i].getModifiers();
            if (Modifier.isPublic(modifier) || Modifier.isProtected(modifier)) {
                throw new IllegalArgumentException("createEnclosingEnumArray: " + constructors[i] + " is not private");
            }
            ++i;
        }
        i = 0;
        while (i < enclosingClzz.length) {
            Class childClz = enclosingClzz[i];
            if (!clz.isAssignableFrom(childClz)) {
                throw new IllegalArgumentException("createEnclosingEnumArray: " + childClz + " is not derived from " + clz);
            }
            if (!Modifier.isFinal(childClz.getModifiers())) {
                throw new IllegalArgumentException("createEnclosingEnumArray: " + childClz + " is not final");
            }
            ++i;
        }
        EnumManager theManager = EnumManager.getManager(clz);
        ArrayList allEnums = new ArrayList();
        EnumManager.populateForward(theManager, allEnums);
        int i2 = 0;
        while (i2 < enclosingClzz.length) {
            EnumManager manager = EnumManager.getManager(enclosingClzz[i2]);
            EnumManager.populateForward(manager, allEnums);
            ++i2;
        }
        Object allEnclosingEnums = null;
        int size = allEnums.size();
        if (size > 0) {
            allEnclosingEnums = Array.newInstance(clz, size);
            int i3 = 0;
            while (i3 < size) {
                Array.set(allEnclosingEnums, i3, allEnums.get(i3));
                ++i3;
            }
        }
        return allEnclosingEnums;
    }

    static Object createInheritedEnumArray(Class clz, Class topClz) {
        if (!BaseEnum.class.isAssignableFrom(topClz)) {
            throw new IllegalArgumentException("createInheriedEnumArray: " + topClz + " is not the right type");
        }
        if (!topClz.isAssignableFrom(clz)) {
            throw new IllegalArgumentException("createInheriedEnumArray: " + topClz + " is not the base type for " + clz);
        }
        EnumManager theManager = EnumManager.getManager(clz);
        ArrayList allEnums = new ArrayList();
        while (theManager != null) {
            EnumManager.populateBackward(theManager, allEnums);
            if (clz == topClz) break;
            clz = clz.getSuperclass();
            theManager = EnumManager.getManager(clz);
        }
        Object allInheritedEnums = null;
        int size = allEnums.size();
        if (size > 0) {
            allInheritedEnums = Array.newInstance(topClz, size);
            int i = 0;
            while (i < size) {
                Array.set(allInheritedEnums, i, allEnums.get(i));
                ++i;
            }
        }
        return allInheritedEnums;
    }

    static final int size(Class type) {
        return EnumManager.getManager(type).size();
    }

    private void addToManager(BaseEnum theEnum) {
        if (theEnum == null) {
            throw new IllegalArgumentException("add(BaseEnum) entry must not be null");
        }
        int id = theEnum.getId();
        if (this.m_map.containsKey(id)) {
            throw new IllegalArgumentException("BaseEnum with value: " + id + " already exists");
        }
        if (theEnum.m_nextEnum != null) {
            throw new IllegalArgumentException("add(BaseEnum) must have entry.next == null");
        }
        if (theEnum.m_previousEnum != null) {
            throw new IllegalArgumentException("add(BaseEnum) must have entry.prev == null");
        }
        if (this.m_firstEnum == null) {
            this.m_firstEnum = theEnum;
        } else {
            theEnum.m_previousEnum = this.m_lastEnum;
            this.m_lastEnum.m_nextEnum = theEnum;
        }
        this.m_lastEnum = theEnum;
        this.m_map.put(id, theEnum);
    }

    private final BaseEnum get(Class type, int id) {
        BaseEnum result = this.m_map.get(id);
        if (result == null) {
            EnumManager.loadClass(type);
            result = this.m_map.get(id);
            if (result == null) {
                this.logDebug(id);
            }
        }
        return result;
    }

    private final BaseEnum get(Class type, String name) {
        if (name == null) {
            return null;
        }
        BaseEnum enumX = this.doGet(name);
        if (enumX == null) {
            EnumManager.loadClass(type);
            enumX = this.doGet(name);
        }
        return enumX;
    }

    private BaseEnum doGet(String name) {
        BaseEnum enumX = this.first();
        while (enumX != null) {
            if (enumX.getName().equals(name)) {
                return enumX;
            }
            enumX = enumX.next();
        }
        return null;
    }

    private final BaseEnum getIgnoreCase(Class type, String matchName) {
        if (matchName == null) {
            return null;
        }
        BaseEnum enumX = this.doGetIgnoreCase(matchName);
        if (enumX == null) {
            EnumManager.loadClass(type);
            enumX = this.doGetIgnoreCase(matchName);
        }
        return enumX;
    }

    private BaseEnum doGetIgnoreCase(String matchName) {
        BaseEnum enumX = this.first();
        while (enumX != null) {
            String enumName = enumX.getName();
            if (matchName.equalsIgnoreCase(enumName)) {
                return enumX;
            }
            enumX = enumX.next();
        }
        return null;
    }

    private final BaseEnum getElseReturn(Class type, int id, BaseEnum elseEnum) {
        BaseEnum result = this.m_map.get(id);
        if (result == null) {
            EnumManager.loadClass(type);
            result = this.m_map.get(id);
            if (result == null) {
                this.logDebug(id);
            }
        }
        return result == null ? elseEnum : result;
    }

    public void logDebug(int id) {
        if (!EnumManager.getLogger().isDebugEnabled()) {
            return;
        }
        Class<?> type = null;
        if (this.m_firstEnum != null) {
            type = this.m_firstEnum.getClass();
        }
        StringBuilder msg = new StringBuilder();
        msg.append("enum alert!!!");
        if (type != null) {
            msg.append(" type=" + type.getName());
        }
        msg.append(" key=" + id);
        msg.append(" intMapSize" + this.m_map.size() + "\n");
        msg.append("KeySet = " + this.m_map.keySet());
        EnumManager.getLogger().log(LogLevel.DEBUG, msg.toString());
    }

    private final List getList() {
        ArrayList<BaseEnum> answer = new ArrayList<BaseEnum>(this.size());
        BaseEnum enumX = this.first();
        while (enumX != null) {
            answer.add(enumX);
            enumX = enumX.next();
        }
        return answer;
    }

    private final ListIterator iterator() {
        return new ListIterator(){
            BaseEnum cur = null;
            BaseEnum next;
            int ix;
            {
                this.next = EnumManager.this.first();
                this.ix = 0;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Object next() {
                if (this.next == null) {
                    throw new NoSuchElementException("no next element");
                }
                this.cur = this.next;
                this.next = this.next.next();
                ++this.ix;
                return this.cur;
            }

            @Override
            public boolean hasPrevious() {
                return this.cur != null ? this.cur.previous() != null : false;
            }

            public Object previous() {
                if (this.cur == null || this.cur.previous() == null) {
                    throw new NoSuchElementException("no previous element");
                }
                --this.ix;
                this.next = this.cur;
                this.cur = this.cur.previous();
                return this.cur;
            }

            @Override
            public int nextIndex() {
                return this.ix;
            }

            @Override
            public int previousIndex() {
                return this.ix - 2 < 0 ? -1 : this.ix - 2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            public void set(Object o) {
                throw new UnsupportedOperationException("set");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("add");
            }
        };
    }

    private final int size() {
        return this.m_map.size();
    }

    private final BaseEnum first() {
        return this.m_firstEnum;
    }

    private final BaseEnum last() {
        return this.m_lastEnum;
    }

    private static EnumManager getManager(Class type) {
        EnumManager aManager = (EnumManager)s_managers.get(type);
        if (aManager == null) {
            aManager = new EnumManager();
            EnumManager oldManager = s_managers.putIfAbsent(type, aManager);
            if (oldManager != null) {
                aManager = oldManager;
            }
            EnumManager.loadClass(type);
        }
        return aManager;
    }

    private static void loadClass(Class cls) {
        JdkUtil.forceInit(cls);
    }

    private static void populateForward(EnumManager manager, List list) {
        BaseEnum enumX = manager.first();
        while (enumX != null) {
            list.add(enumX);
            enumX = enumX.next();
        }
    }

    private static void populateBackward(EnumManager manager, List list) {
        BaseEnum enumX = manager.last();
        while (enumX != null) {
            list.add(0, enumX);
            enumX = enumX.previous();
        }
    }
}

