/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.enums;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.vjet.dsf.common.enums.EnumManager;

public abstract class BaseEnum
implements Cloneable,
Serializable {
    public static final long serialVersionUID = -3864257445388624423L;
    private final int m_id;
    private final transient String m_name;
    transient BaseEnum m_nextEnum = null;
    transient BaseEnum m_previousEnum = null;

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    protected BaseEnum(int id, String name) {
        this(id, name, true);
    }

    protected BaseEnum(int id, String name, boolean register) {
        this.m_id = id;
        this.m_name = name;
        if (register) {
            EnumManager.add(this);
        }
    }

    public final String getName() {
        return this.m_name;
    }

    public final int getId() {
        return this.m_id;
    }

    public final int getValue() {
        return this.getId();
    }

    public final Integer getInteger() {
        return this.getId();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getClass() == other.getClass() && this.m_id == ((BaseEnum)other).m_id;
    }

    public int hashCode() {
        return this.m_id;
    }

    public String toString() {
        return String.valueOf(this.m_name) + "=" + this.m_id;
    }

    public final BaseEnum next() {
        return this.m_nextEnum;
    }

    public final BaseEnum previous() {
        return this.m_previousEnum;
    }

    public static List getList(Class type) {
        return EnumManager.getList(type);
    }

    public static ListIterator getIterator(Class type) {
        return EnumManager.getIterator(type);
    }

    public static final BaseEnum getEnum(Class type, int id) {
        return EnumManager.getEnum(type, id);
    }

    public static final BaseEnum getEnum(Class type, String name) {
        return EnumManager.getEnum(type, name);
    }

    public static final BaseEnum getEnumIgnoreCase(Class type, String name) {
        return EnumManager.getEnumIgnoreCase(type, name);
    }

    public static final BaseEnum getEnum(Class type, Integer id) {
        return EnumManager.getEnum(type, id);
    }

    public static final BaseEnum getElseReturnEnum(Class type, int id, BaseEnum defaultEnum) {
        return EnumManager.getElseEnum(type, id, defaultEnum);
    }

    protected static Object createEnclosedEnumArray(Class clz, Class[] enclosingClzz) {
        return EnumManager.createEnclosedEnumArray(clz, enclosingClzz);
    }

    protected static Object createInheritedEnumArray(Class clz, Class topClz) {
        return EnumManager.createInheritedEnumArray(clz, topClz);
    }

    protected Object readResolve() throws ObjectStreamException {
        return BaseEnum.getEnum(this.getClass(), this.m_id);
    }
}

