/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.ts.group.Group;

public class GroupSymbolMapTable<T, D> {
    private Group<T> m_group;
    private Map<String, GlobalSymbolMapEntry<D>> m_globalVarSymbolTable = new LinkedHashMap<String, GlobalSymbolMapEntry<D>>();
    private Map<String, Set<String>> m_ownerTypeAndGlobalVarMapping = new HashMap<String, Set<String>>();
    private Map<String, Map<String, GlobalSymbolMapEntry<D>>> m_extendedGlobalVars = new LinkedHashMap<String, Map<String, GlobalSymbolMapEntry<D>>>();
    private Map<String, String> m_extensionPointMapping = new HashMap<String, String>();
    private Set<String> m_globalTypeNameList = new LinkedHashSet<String>();

    public GroupSymbolMapTable(Group<T> group) {
        this.m_group = group;
    }

    public synchronized void addGlobalType(String type) {
        this.m_globalTypeNameList.add(type);
    }

    public synchronized void addGlobal(String varName, String typeName) {
        this.addGlobal(varName, typeName, false);
    }

    public synchronized void addGlobal(String varName, String typeName, boolean directTypeMapping) {
        GlobalSymbolMapEntry<Object> entry = this.addGlobal(varName, typeName, null);
        entry.setDirectTypeMapping(directTypeMapping);
    }

    public synchronized GlobalSymbolMapEntry<D> addGlobal(String varName, String typeName, D node) {
        String scope;
        GlobalSymbolMapEntry<D> entry = null;
        if (node instanceof IJstGlobalVar && (scope = ((IJstGlobalVar)node).getScopeForGlobal()) != null) {
            Map<String, GlobalSymbolMapEntry<D>> map = this.m_extendedGlobalVars.get(scope);
            if (map == null) {
                map = new LinkedHashMap<String, GlobalSymbolMapEntry<D>>();
                this.m_extendedGlobalVars.put(scope, map);
                this.m_extensionPointMapping.put(typeName, scope);
            } else {
                entry = map.get(varName);
            }
            if (entry == null) {
                entry = new GlobalSymbolMapEntry<D>(varName, typeName, node);
                map.put(varName, entry);
            }
            return entry;
        }
        entry = this.m_globalVarSymbolTable.get(varName);
        if (entry == null) {
            entry = new GlobalSymbolMapEntry<D>(varName, typeName, node);
            this.m_globalVarSymbolTable.put(varName, entry);
            Set<String> varsFromType = this.m_ownerTypeAndGlobalVarMapping.get(typeName);
            if (varsFromType == null) {
                varsFromType = new HashSet<String>();
                this.m_ownerTypeAndGlobalVarMapping.put(typeName, varsFromType);
            }
            varsFromType.add(varName);
        }
        return entry;
    }

    public List<GlobalSymbolMapEntry<D>> getAllGlobalTypes() {
        ArrayList<GlobalSymbolMapEntry<D>> list = new ArrayList<GlobalSymbolMapEntry<D>>();
        for (GlobalSymbolMapEntry<T> globalSymbolMapEntry : this.m_globalVarSymbolTable.values()) {
            if (globalSymbolMapEntry.getNode() == null || !(globalSymbolMapEntry.getNode() instanceof IJstType)) continue;
            D node = globalSymbolMapEntry.getNode();
            if (node == null) {
                T type = this.m_group.getEntity(globalSymbolMapEntry.getOwnerTypeName());
                if (type == null) continue;
                globalSymbolMapEntry.setNode(type);
                list.add(globalSymbolMapEntry);
                continue;
            }
            list.add(globalSymbolMapEntry);
        }
        return list;
    }

    public T getGlobalType(String typeName) {
        GlobalSymbolMapEntry<D> entry = this.m_globalVarSymbolTable.get(typeName);
        if (entry == null || !entry.isDirectTypeMapping()) {
            return null;
        }
        D node = entry.getNode();
        if (node == null) {
            node = this.findGlobalNode(entry);
        }
        return (T)node;
    }

    public List<D> getAllGlobalVars() {
        ArrayList<D> list = new ArrayList<D>();
        for (GlobalSymbolMapEntry<D> entry : this.m_globalVarSymbolTable.values()) {
            D node = entry.getNode();
            if (node == null) {
                node = this.findGlobalNode(entry);
            }
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public D getGlobalVar(String varName) {
        GlobalSymbolMapEntry<D> entry = this.m_globalVarSymbolTable.get(varName);
        if (entry == null) {
            return null;
        }
        D node = entry.getNode();
        if (node == null) {
            node = this.findGlobalNode(entry);
        }
        return node;
    }

    public boolean hasExtension(String globalVarName) {
        return this.m_extendedGlobalVars.containsKey(globalVarName);
    }

    public List<D> getExtensions(String globalVarName) {
        Map<String, GlobalSymbolMapEntry<D>> extensionMap = this.m_extendedGlobalVars.get(globalVarName);
        if (extensionMap == null) {
            return null;
        }
        ArrayList<D> extensions = new ArrayList<D>(extensionMap.size());
        for (GlobalSymbolMapEntry<D> entry : extensionMap.values()) {
            D node = entry.getNode();
            if (node == null) {
                node = this.findGlobalNode(entry);
            }
            if (node == null) continue;
            extensions.add(node);
        }
        return extensions;
    }

    private D findGlobalNode(GlobalSymbolMapEntry<D> entry) {
        String typeName = entry.getOwnerTypeName();
        IJstType type = (IJstType)this.m_group.getEntity(typeName);
        if (type != null) {
            IJstNode glbvar = null;
            if (entry.isDirectTypeMapping()) {
                glbvar = type;
                entry.setNode((IJstType)glbvar);
                return (D)glbvar;
            }
            glbvar = type.getGlobalVar(entry.getName());
            if (glbvar != null) {
                entry.setNode((IJstType)glbvar);
                return (D)glbvar;
            }
        }
        return null;
    }

    public D getGlobalMethod(String methodName) {
        GlobalSymbolMapEntry<D> entry = this.m_globalVarSymbolTable.get(methodName);
        if (entry == null) {
            return null;
        }
        D method = entry.getNode();
        if (method == null) {
            method = this.findGlobalNode(entry);
        }
        if (!(method instanceof IJstMethod)) {
            return null;
        }
        return method;
    }

    public synchronized void promoteGlobalTypeMembers() {
        if (this.m_globalTypeNameList.isEmpty()) {
            return;
        }
        ArrayList<JstType> typeList = new ArrayList<JstType>();
        HashSet<String> unresolvedGlobalTypeList = new HashSet<String>();
        for (String typeName : this.m_globalTypeNameList) {
            JstType type = (JstType)this.m_group.getEntity(typeName);
            if (type != null) {
                typeList.add(type);
                continue;
            }
            unresolvedGlobalTypeList.add(typeName);
        }
        this.promoteAllMembers(typeList);
        this.m_globalTypeNameList.clear();
        this.m_globalTypeNameList = unresolvedGlobalTypeList;
    }

    private synchronized void promoteAllMembers(List<JstType> typeList) {
        for (JstType jstType : typeList) {
            String typeName = jstType.getName();
            for (IJstProperty pty : jstType.getProperties()) {
                this.addGlobal(pty.getName().getName(), typeName, pty);
            }
            for (IJstMethod method : jstType.getMethods()) {
                this.addGlobal(method.getName().getName(), typeName, method);
            }
        }
    }

    public synchronized void removeGlobalVarsFromType(String typeName) {
        Set<String> varsFromType = this.m_ownerTypeAndGlobalVarMapping.remove(typeName);
        if (varsFromType != null) {
            for (String varName : varsFromType) {
                this.m_globalVarSymbolTable.remove(varName);
            }
            return;
        }
        String extensionPoint = this.m_extensionPointMapping.remove(typeName);
        if (extensionPoint != null) {
            Map<String, GlobalSymbolMapEntry<D>> extendedMap = this.m_extendedGlobalVars.get(extensionPoint);
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (Map.Entry<String, GlobalSymbolMapEntry<D>> entry : extendedMap.entrySet()) {
                if (!typeName.equals(entry.getValue().getOwnerTypeName())) continue;
                keysToRemove.add(entry.getKey());
            }
            for (String extended : keysToRemove) {
                extendedMap.remove(extended);
            }
            if (extendedMap.isEmpty()) {
                this.m_extendedGlobalVars.remove(extensionPoint);
            }
        }
    }

    public static class GlobalSymbolMapEntry<D> {
        private String m_name;
        private String m_ownerTypeName;
        private D m_jstNode;
        private boolean m_isDirectTypeMapping = false;

        GlobalSymbolMapEntry(String name, String ownerTypeName, D node) {
            this.m_name = name;
            this.m_ownerTypeName = ownerTypeName;
            this.m_jstNode = node;
        }

        public String getName() {
            return this.m_name;
        }

        public D getNode() {
            return this.m_jstNode;
        }

        boolean isDirectTypeMapping() {
            return this.m_isDirectTypeMapping;
        }

        GlobalSymbolMapEntry<D> setDirectTypeMapping(boolean set) {
            this.m_isDirectTypeMapping = set;
            return this;
        }

        String getOwnerTypeName() {
            return this.m_ownerTypeName;
        }

        void setNode(D node) {
            this.m_jstNode = node;
        }
    }
}

