/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.graph.DependencyNode;
import org.eclipse.vjet.dsf.ts.graph.IDependencyCollector;
import org.eclipse.vjet.dsf.ts.graph.IDependencyGraph;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.util.CollectionHelper;

public class DependencyGraph<E>
implements IDependencyGraph<E> {
    private final Map<String, DependencyNode<E>> m_nodes = new LinkedHashMap<String, DependencyNode<E>>();
    private final IDependencyCollector<E> m_collector;
    private final Group<E> m_group;
    private Direction m_direction = Direction.BOTH;

    public DependencyGraph(IDependencyCollector<E> builder) {
        this(null, builder, null);
    }

    public DependencyGraph(Map<String, E> entities, IDependencyCollector<E> builder) {
        this(entities, builder, null);
    }

    public DependencyGraph(IDependencyCollector<E> builder, Group<E> group) {
        this(null, builder, group);
    }

    public DependencyGraph(Map<String, E> entities, IDependencyCollector<E> builder, Group<E> group) {
        assert (builder != null) : "builder cannot be null";
        if (group == null) {
            this.m_group = new Group<E>("DefaultGroup", builder);
            this.m_group.setTypeSpace(new TypeSpace());
            this.m_group.setGraph(this);
        } else {
            this.m_group = group;
        }
        this.m_collector = builder;
        this.m_group.addEntities(entities, true);
    }

    @Override
    public E getEntity(String name) {
        return this.m_group.getEntity(name);
    }

    @Override
    public Map<String, E> getEntities() {
        return this.m_group.getEntities();
    }

    @Override
    public List<E> getDirectDependencies(String name, boolean internalOnly) {
        DependencyNode<E> node = this.getNode(name);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<E> list = new ArrayList<E>();
        for (DependencyNode<E> d : node.getDependencies().values()) {
            E dEntity = d.getEntity();
            if (internalOnly && !this.getEntities().containsValue(dEntity)) continue;
            list.add(dEntity);
        }
        return list;
    }

    @Override
    public List<E> getIndirectDependencies(String name, boolean internalOnly) {
        DependencyNode<E> node = this.getNode(name);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        ArrayList<DependencyNode<DependencyNode<E>>> visited = new ArrayList<DependencyNode<DependencyNode<E>>>();
        visited.add(node);
        this.collectDependency(node, list, visited, 0, internalOnly);
        return list;
    }

    @Override
    public List<E> getAllDependencies(String name, boolean internalOnly) {
        DependencyNode<E> node = this.getNode(name);
        if (node == null) {
            return Collections.emptyList();
        }
        return CollectionHelper.merge(this.getDirectDependencies(name, internalOnly), this.getIndirectDependencies(name, internalOnly));
    }

    @Override
    public List<E> getDirectDependents(String name, boolean internalOnly) {
        DependencyNode<E> node = this.getNode(name);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<E> list = new ArrayList<E>();
        for (DependencyNode<E> d : node.getDependents().values()) {
            E dEntity = d.getEntity();
            if (internalOnly && !this.getEntities().containsValue(dEntity)) continue;
            list.add(dEntity);
        }
        return list;
    }

    @Override
    public List<E> getIndirectDependents(String name, boolean internalOnly) {
        DependencyNode<E> node = this.getNode(name);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        ArrayList<DependencyNode<DependencyNode<E>>> visited = new ArrayList<DependencyNode<DependencyNode<E>>>();
        visited.add(node);
        this.collectDependents(node, list, visited, 0, internalOnly);
        return list;
    }

    @Override
    public List<E> getAllDependents(String name, boolean internalOnly) {
        DependencyNode<E> node = this.getNode(name);
        if (node == null) {
            return Collections.emptyList();
        }
        return CollectionHelper.merge(this.getDirectDependents(name, internalOnly), this.getIndirectDependents(name, internalOnly));
    }

    public void setDirection(Direction direction) {
        this.m_direction = direction;
    }

    public boolean addEntity(String name, E entity) {
        return this.m_group.addEntity(name, entity, true);
    }

    public synchronized void addEntities(Map<String, ? extends E> entities) {
        this.m_group.addEntities(entities, true);
    }

    public void renameEntity(String oldName, String newName) {
        this.m_group.renameEntity(oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameNode(String oldName, String newName) {
        DependencyNode<E> node = this.getNodes().get(oldName);
        if (node != null) {
            DependencyGraph dependencyGraph = this;
            synchronized (dependencyGraph) {
                this.m_nodes.remove(oldName);
                this.m_nodes.put(newName, node);
            }
        }
    }

    public void addEntityDependency(String entityNameA, String entityNameB) {
        DependencyNode<E> aNode = this.getNode(entityNameA);
        if (aNode == null) {
            throw new RuntimeException("entity not found for:" + entityNameA);
        }
        DependencyNode<E> bNode = this.getNode(entityNameB);
        if (bNode == null) {
            throw new RuntimeException("entity not found for:" + entityNameB);
        }
        this.addDependency(aNode, bNode);
    }

    public void removeEntityDependency(String entityNameA, String entityNameB) {
        DependencyNode<E> aNode = this.getNode(entityNameA);
        if (aNode == null) {
            throw new RuntimeException("entity not found for:" + entityNameA);
        }
        DependencyNode<E> bNode = this.getNode(entityNameB);
        if (bNode == null) {
            throw new RuntimeException("entity not found for:" + entityNameB);
        }
        this.removeDependency(aNode, bNode);
    }

    public void removeEntity(String name) {
        this.m_group.removeEntity(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependencyNode(String name) {
        DependencyNode<E> node = this.getNodes().get(name);
        if (node != null) {
            DependencyGraph dependencyGraph = this;
            synchronized (dependencyGraph) {
                this.m_nodes.remove(name);
            }
            this.m_group.getTypeSpace().addUnresolvedNode(node);
            for (DependencyNode<E> d : node.getDependencies().values()) {
                d.removeDependent(node);
            }
        }
    }

    public synchronized Map<String, DependencyNode<E>> getUnresolvedNodes() {
        return Collections.unmodifiableMap(this.m_group.getTypeSpace().getUnresolvedNodes());
    }

    public Group<E> getGroup() {
        return this.m_group;
    }

    public String toString() {
        Z z = new Z();
        Collection<DependencyNode<E>> nodes = this.getNodes().values();
        z.format((Object)"Types: ");
        for (String string : this.m_group.getEntities().keySet()) {
            z.format((Object)(" * " + string));
        }
        for (DependencyNode dependencyNode : nodes) {
            z.format((Object)dependencyNode.toString());
        }
        return z.toString();
    }

    public void addToGraph(String name, E entity) {
        Map<String, E> entity_dependencies = this.m_collector.getDependency(entity);
        DependencyNode<E> node = this.getNode(name, entity, true);
        for (Map.Entry<String, E> entry : entity_dependencies.entrySet()) {
            DependencyNode<E> dependency_node = this.getNode(entry.getKey(), entry.getValue(), true);
            this.addDependency(node, dependency_node);
        }
    }

    public void addImplicitDependency(String name, E entity, String dependencyGrpName, String dependencyName, E dependency) {
        DependencyNode<E> node = this.getNode(name, entity, true);
        IGroup group = this.m_group.getTypeSpace().getGroup(dependencyGrpName);
        DependencyNode<E> dependencyNode = super.getNode(dependencyName, dependency, true);
        this.addDependency(node, dependencyNode);
    }

    private synchronized Map<String, DependencyNode<E>> getNodes() {
        return Collections.unmodifiableMap(this.m_nodes);
    }

    private DependencyNode<E> getNode(String name) {
        return this.getNode(name, this.getEntity(name), false);
    }

    private DependencyNode<E> getNode(String name, E entity, boolean create) {
        Map<String, E> entities = this.m_group.getEntities();
        if (entity != null && entities.containsValue(entity)) {
            DependencyNode<E> node = this.getNodes().get(name);
            if (node == null && create) {
                node = new DependencyNode<E>(name, entity, this);
                this.addNode(name, node);
            }
            return node;
        }
        Group<E> group = this.m_group.getTypeSpace().getDependencyGroup(this.m_group.getName(), entity);
        if (group == null) {
            group = this.m_group.getTypeSpace().getGroup(entity);
        }
        if (group != null) {
            return super.getNode(name, entity, create);
        }
        DependencyNode<E> node = null;
        node = this.m_group.getTypeSpace().getUnresolvedNodes().get(name);
        if (node == null && create) {
            node = new DependencyNode<E>(name, entity, null);
            this.m_group.getTypeSpace().addUnresolvedNode(node);
        }
        return node;
    }

    private void addDependency(DependencyNode<E> aNode, DependencyNode<E> bNode) {
        if (aNode == null) {
            throw new RuntimeException("aNode is null");
        }
        if (bNode == null) {
            throw new RuntimeException("bNode is null");
        }
        if (this.m_direction != Direction.DEPENDENT_ONLY) {
            aNode.addDependency(bNode);
        }
        if (this.m_direction != Direction.DEPENDENCY_ONLY) {
            bNode.addDependent(aNode);
        }
    }

    private void removeDependency(DependencyNode<E> aNode, DependencyNode<E> bNode) {
        if (aNode == null) {
            throw new RuntimeException("aNode is null");
        }
        if (bNode == null) {
            throw new RuntimeException("bNode is null");
        }
        if (this.m_direction != Direction.DEPENDENT_ONLY) {
            aNode.removeDependency(bNode);
        }
        if (this.m_direction != Direction.DEPENDENCY_ONLY) {
            bNode.removeDependent(aNode);
        }
    }

    public synchronized void addNode(String name, DependencyNode<E> node) {
        this.m_nodes.put(name, node);
    }

    private void collectDependency(DependencyNode<E> node, List<E> collector, List<DependencyNode<E>> visited, int level, boolean internalOnly) {
        for (DependencyNode<E> d : node.getDependencies().values()) {
            if (visited.contains(d)) continue;
            if (level > 0) {
                E dEntity = d.getEntity();
                if (!internalOnly || this.getEntities().containsValue(dEntity)) {
                    collector.add(dEntity);
                }
            }
            visited.add(d);
            this.collectDependency(d, collector, visited, level + 1, internalOnly);
        }
    }

    private void collectDependents(DependencyNode<E> node, List<E> collector, List<DependencyNode<E>> visited, int level, boolean internalOnly) {
        for (DependencyNode<E> d : node.getDependents().values()) {
            if (visited.contains(d)) continue;
            if (level > 0) {
                E dEntity = d.getEntity();
                if (!internalOnly || this.getEntities().containsValue(dEntity)) {
                    collector.add(dEntity);
                }
            }
            visited.add(d);
            this.collectDependents(d, collector, visited, level + 1, internalOnly);
        }
    }

    public static enum Direction {
        DEPENDENCY_ONLY,
        DEPENDENT_ONLY,
        BOTH;

    }
}

