/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.util.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class JsBuilderDef {
    private final JstType m_type;
    private final Map<String, Section> m_sections = new LinkedHashMap<String, Section>();
    private final Map<String, List<Section>> m_anyOrderGrps = new LinkedHashMap<String, List<Section>>();
    private List<List<Section>> m_anyOrderGrp = new ArrayList<List<Section>>();

    public JsBuilderDef() {
        this.m_type = null;
    }

    public JsBuilderDef(String pkg, String type) {
        this.m_type = this.getType(type);
        this.m_type.setPackage(new JstPackage(pkg));
    }

    private final JstType getType(String type) {
        JstType typeFromCache = JstCache.getInstance().getType(type);
        if (typeFromCache != null) {
            return typeFromCache;
        }
        return JstFactory.getInstance().createJstType(type, true);
    }

    public JsBuilderDef mtd(String string, int min, int max) {
        this.m_sections.put(string, new Section(string, min, max));
        return this;
    }

    public JsBuilderDef mtd(String string, int min, String max) {
        this.m_sections.put(string, new Section(string, min, max));
        return this;
    }

    public JsBuilderDef anyOrder(JsBuilderDef def) {
        Section firstDef = null;
        ArrayList<Section> secs = new ArrayList<Section>();
        this.m_anyOrderGrp.add(secs);
        for (Section s : def.m_sections.values()) {
            if (firstDef == null) {
                firstDef = s;
            }
            s.m_anyOrder = true;
            secs.add(s);
            this.m_anyOrderGrps.put(s.getMtd(), secs);
            this.m_sections.put(s.getMtd(), s);
        }
        return this;
    }

    public JstType getType() {
        return this.m_type;
    }

    public List<Section> getSections() {
        ArrayList<Section> sec = new ArrayList<Section>(this.m_sections.size());
        sec.addAll(this.m_sections.values());
        return sec;
    }

    public List<Section> getAnyOrderGroup(String name) {
        if (this.m_anyOrderGrps.get(name) == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_anyOrderGrps.get(name);
    }

    public List<Section> getAnyOrderGroupMaxOne(String name) {
        ArrayList<Section> list = new ArrayList<Section>();
        for (Section s : this.getAnyOrderGroup(name)) {
            if (s.m_max != 1) continue;
            list.add(s);
        }
        return list;
    }

    public List<List<Section>> getAnyOrderGrp() {
        return this.m_anyOrderGrp;
    }

    public List<List<Section>> getAnyOrderMaxOneGrp() {
        ArrayList<List<Section>> list = new ArrayList<List<Section>>();
        for (List<Section> sec : this.m_anyOrderGrp) {
            ArrayList<Section> sec2 = new ArrayList<Section>();
            for (Section section : sec) {
                if (section.getMax() != 1) continue;
                sec2.add(section);
            }
            list.add(sec2);
        }
        return list;
    }

    public List<Section> getNextOrderSections(String mtd) {
        ArrayList<Section> nextOrderSections = new ArrayList<Section>();
        boolean findNextSection = false;
        for (Section sec : this.m_sections.values()) {
            if (sec.getMtd().equals(mtd)) {
                findNextSection = true;
                continue;
            }
            if (!findNextSection || sec.getMtd().equals(mtd)) continue;
            nextOrderSections.add(sec);
        }
        return nextOrderSections;
    }

    public class Section {
        private final String m_mtd;
        private final int m_min;
        private final int m_max;
        private boolean m_anyOrder;

        public Section(String mtd, int min, int max) {
            this.m_mtd = mtd;
            this.m_min = min;
            this.m_max = max;
        }

        public Section(String mtd, int min, String max) {
            this.m_mtd = mtd;
            this.m_min = min;
            this.m_max = max.equals("*") ? Integer.MAX_VALUE : new Integer(max);
        }

        public String getMtd() {
            return this.m_mtd;
        }

        public int getMin() {
            return this.m_min;
        }

        public int getMax() {
            return this.m_max;
        }

        public boolean isAnyOrder() {
            return this.m_anyOrder;
        }
    }
}

