/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.graph.DependencyGraph;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.IGroup;

abstract class ADependencyVisitor<T>
implements IJstVisitor {
    protected TypeSpace m_ts;
    protected Map<T, List<IJstNode>> m_dependencies = new LinkedHashMap<T, List<IJstNode>>();

    ADependencyVisitor() {
    }

    protected List<IJstNode> get_dep_list(T key) {
        List<IJstNode> dependencies = this.m_dependencies.get(key);
        if (dependencies == null) {
            dependencies = new ArrayList<IJstNode>();
            this.m_dependencies.put(key, dependencies);
        }
        return dependencies;
    }

    protected void add_if_absent(T key, IJstNode d) {
        List<IJstNode> dependencies = this.m_dependencies.get(key);
        if (dependencies == null) {
            dependencies = new ArrayList<IJstNode>();
            this.m_dependencies.put(key, dependencies);
        } else if (dependencies.contains(d)) {
            return;
        }
        dependencies.add(d);
    }

    public void setTypeSpace(TypeSpace ts) {
        this.m_ts = ts;
    }

    protected void addImplicitDependency(IJstNode dependent, String dependencyGrp, IJstType dependency) {
        IGroup group;
        String thisGroupName = null;
        if (dependent.getOwnerType().getPackage() != null) {
            thisGroupName = dependent.getOwnerType().getPackage().getGroupName();
        }
        if (thisGroupName != null && (group = this.m_ts.getGroup(thisGroupName)) != null) {
            ((DependencyGraph)((Group)group).getGraph()).addImplicitDependency(dependent.getOwnerType().getName(), dependent.getOwnerType(), dependencyGrp, dependency.getName(), dependency);
        }
    }
}

