/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.io.InputStream;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.GroupMgr;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.ITypeSpaceLoader;
import org.eclipse.vjet.dsf.jst.ts.JstEventListener;
import org.eclipse.vjet.dsf.jst.ts.JstQueryExecutor;
import org.eclipse.vjet.dsf.jst.ts.JstResourceMgr;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceLoader;
import org.eclipse.vjet.dsf.jst.ts.MethodIndexMgr;
import org.eclipse.vjet.dsf.jst.ts.PropertyIndexMgr;
import org.eclipse.vjet.dsf.jst.ts.TypeDependencyMgr;
import org.eclipse.vjet.dsf.jst.ts.TypeSpaceConfig;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.event.EventListenerStatus;
import org.eclipse.vjet.dsf.ts.event.ISourceEvent;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.ISourceEventListener;
import org.eclipse.vjet.dsf.ts.event.ITypeSpaceEventListener;
import org.eclipse.vjet.dsf.ts.event.TypeSpaceEvent;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventListenerHandle;
import org.eclipse.vjet.dsf.ts.event.dispatch.SourceEventDispatcher;
import org.eclipse.vjet.dsf.ts.event.dispatch.TypeSpaceEventDispatcher;

public final class JstTypeSpaceMgr {
    public static final String JS_BROWSER_GRP = "JsBrowserLib";
    public static final String JS_NATIVE_GRP = "JsNativeLib";
    public static final String JAVA_PRIMITIVE_GRP = "JavaPrimitive";
    public static final String VJO_BASE_LIB_NAME = "VjoBaseLib";
    public static final String VJO_SELF_DESCRIBED = "VjoSelfDescribed";
    private boolean m_initialized = false;
    private final TypeSpace<IJstType, IJstNode> m_ts = new TypeSpace();
    private final JstQueryExecutor m_queryExecutor;
    private final ITypeSpaceLoader m_tsLoader;
    private final IJstParseController m_jstParseController;
    private final GroupMgr m_groupMgr = new GroupMgr(this);
    private final TypeDependencyMgr m_typeDependencyMgr = new TypeDependencyMgr(this);
    private final PropertyIndexMgr m_ptyIndexMgr;
    private final MethodIndexMgr m_mtdIndexMgr;
    private final JstResourceMgr m_resourceMgr = new JstResourceMgr(this);
    private TypeSpaceConfig m_config;
    private final SourceEventDispatcher m_srcEventDispatcher = new SourceEventDispatcher();
    private final TypeSpaceEventDispatcher m_tsEventDispatcher;

    public JstTypeSpaceMgr(IJstParseController controller, IJstTypeLoader loader) {
        this.m_srcEventDispatcher.addListener(new JstEventListener(this));
        this.m_queryExecutor = new JstQueryExecutor(this.m_ts);
        this.m_mtdIndexMgr = new MethodIndexMgr(this.m_ts, this.m_queryExecutor);
        this.m_ptyIndexMgr = new PropertyIndexMgr(this.m_ts, this.m_queryExecutor);
        this.m_ts.setMethodSymbolTableManager(this.m_mtdIndexMgr);
        this.m_ts.setPropertySymbolTableManager(this.m_ptyIndexMgr);
        this.m_tsEventDispatcher = new TypeSpaceEventDispatcher();
        this.m_tsLoader = new JstTypeSpaceLoader(this, loader);
        this.m_jstParseController = controller;
        if (this.m_jstParseController != null) {
            this.m_jstParseController.setJstTSMgr(this);
        }
    }

    public JstTypeSpaceMgr initialize() {
        if (!this.m_initialized) {
            this.m_srcEventDispatcher.setConfig(this.getConfig());
            this.m_tsEventDispatcher.setConfig(this.getConfig());
            this.m_resourceMgr.initialize();
            this.m_initialized = true;
            this.m_tsEventDispatcher.dispatch(new TypeSpaceEvent(TypeSpaceEvent.EventId.Init), new EventListenerStatus(EventListenerStatus.Code.Successful));
        }
        return this;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public JstTypeSpaceMgr setConfig(TypeSpaceConfig config) {
        this.m_config = config;
        return this;
    }

    public TypeSpaceConfig getConfig() {
        if (this.m_config == null) {
            this.m_config = new TypeSpaceConfig();
        }
        return this.m_config;
    }

    public ITypeSpace<IJstType, IJstNode> getTypeSpace() {
        return this.m_ts;
    }

    public JstQueryExecutor getQueryExecutor() {
        return this.m_queryExecutor;
    }

    public void processEvent(ISourceEvent event) {
        if (!this.m_initialized || event == null) {
            return;
        }
        this.m_srcEventDispatcher.dispatch(event);
    }

    public IEventListenerHandle processEvent(ISourceEvent<IEventListenerHandle> event, ISourceEventCallback<IJstType> callback) {
        if (!this.m_initialized || event == null) {
            return null;
        }
        return this.m_srcEventDispatcher.dispatch(event, callback);
    }

    public JstTypeSpaceMgr registerTypeSpaceEventListener(ITypeSpaceEventListener listener) {
        this.m_tsEventDispatcher.addListener(listener);
        return this;
    }

    public JstTypeSpaceMgr registerSourceEventListener(ISourceEventListener listener) {
        this.m_srcEventDispatcher.addListener(listener);
        return this;
    }

    public void close() {
        if (!this.m_initialized) {
            return;
        }
        this.m_initialized = false;
        this.m_tsEventDispatcher.dispatch(new TypeSpaceEvent(TypeSpaceEvent.EventId.Unloaded), new EventListenerStatus(EventListenerStatus.Code.Successful));
        this.m_resourceMgr.persistTypeSpace();
    }

    public void loadLibrary(InputStream is, String grpName) {
        if (is == null) {
            throw new RuntimeException("InputStream is null");
        }
        if (grpName == null) {
            throw new RuntimeException("grpName is null");
        }
        this.m_resourceMgr.loadLibrary(is, grpName);
    }

    public void loadLibrary(IJstLib lib, String grpName) {
        if (lib == null) {
            throw new RuntimeException("lib is null");
        }
        if (grpName == null) {
            throw new RuntimeException("grpName is null");
        }
        this.m_resourceMgr.loadLibrary(lib, grpName);
    }

    public static boolean isDefaultLibName(String libName) {
        return libName.equals(JS_NATIVE_GRP) || libName.equals(JAVA_PRIMITIVE_GRP) || libName.equals(VJO_BASE_LIB_NAME) || libName.equals(JS_BROWSER_GRP) || libName.equals(VJO_SELF_DESCRIBED);
    }

    public ITypeSpaceLoader getJstTypeSpaceLoader() {
        return this.m_tsLoader;
    }

    TypeSpace<IJstType, IJstNode> getTypeSpaceImpl() {
        return this.m_ts;
    }

    GroupMgr getGroupMgr() {
        return this.m_groupMgr;
    }

    JstResourceMgr getResourceMgr() {
        return this.m_resourceMgr;
    }

    TypeDependencyMgr getTypeDependencyMgr() {
        return this.m_typeDependencyMgr;
    }

    PropertyIndexMgr getPropertyIndexMgr() {
        return this.m_ptyIndexMgr;
    }

    MethodIndexMgr getMethodIndexMgr() {
        return this.m_mtdIndexMgr;
    }

    TypeSpaceEventDispatcher getTypeSpaceEventDispatcher() {
        return this.m_tsEventDispatcher;
    }

    IJstParseController getJstParseController() {
        return this.m_jstParseController;
    }
}

