/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.Library;
import org.eclipse.vjet.dsf.ts.group.Project;

class GroupMgr {
    private JstTypeSpaceMgr m_tsMgr;

    GroupMgr(JstTypeSpaceMgr tsMgr) {
        assert (tsMgr != null) : "tsMgr cannot be null";
        this.m_tsMgr = tsMgr;
    }

    public Group<IJstType> addGroup(String groupName, String groupPath) {
        return this.addGroup(groupName, groupPath, null, null);
    }

    public Group<IJstType> addGroup(String groupName, String groupPath, String srcPath, List<String> classPaths) {
        String path;
        if (this.m_tsMgr.getTypeSpaceImpl().getGroup(groupName) != null) {
            throw new RuntimeException("Group already exists:" + groupName);
        }
        boolean isLibrary = false;
        if (groupPath != null && ((path = groupPath.toLowerCase()).endsWith(".zip") || path.endsWith(".jar"))) {
            isLibrary = true;
        }
        Group group = null;
        group = isLibrary ? new Library<IJstType>(groupName, groupPath, this.m_tsMgr.getTypeDependencyMgr().getTypeDependencyCollector()) : new Project<IJstType>(groupName, groupPath, srcPath, classPaths, this.m_tsMgr.getTypeDependencyMgr().getTypeDependencyCollector());
        this.m_tsMgr.getTypeSpaceImpl().addGroup(group);
        if (group instanceof Project && classPaths != null) {
            ((Project)group).buildGroupDependency();
        }
        return group;
    }

    public void addGroups(List<AddGroupEvent> groups) {
        for (AddGroupEvent event : groups) {
            this.addGroup(event.getGroupName(), event.getGroupPath(), event.getSourcePath(), event.getClassPath());
        }
    }

    public void removeGroup(String groupName) {
        if (groupName == null) {
            return;
        }
        this.m_tsMgr.getTypeSpaceImpl().removeGroup(groupName);
    }
}

