/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.term;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstIdentifier
extends BaseJstNode
implements ILHS,
ISimpleTerm,
IExpr {
    private static final long serialVersionUID = 1L;
    private String m_name;
    private JstIdentifier m_qualifier;
    private IJstType m_type;
    private IJstNode m_binding;

    public JstIdentifier(String name) {
        this(name, null);
    }

    public JstIdentifier(String name, JstIdentifier qualifier) {
        assert (name != null) : "name is null";
        this.m_name = name;
        this.m_qualifier = qualifier;
        this.addChild(this.m_qualifier);
    }

    @Override
    public String toSimpleTermText() {
        String text;
        StringBuilder sb = new StringBuilder();
        String q = null;
        if (this.m_qualifier != null) {
            q = this.m_qualifier.toSimpleTermText();
        }
        if (q != null) {
            sb.append(q);
        }
        if (q != null && this.m_name != null) {
            sb.append(".");
        }
        if (this.m_name != null) {
            sb.append(this.m_name);
        }
        return (text = sb.toString()).length() > 0 ? text : null;
    }

    @Override
    public IJstType getType() {
        if (this.m_type != null) {
            return this.m_type;
        }
        if (this.m_binding != null) {
            if (this.m_binding instanceof IJstProperty) {
                return ((IJstProperty)this.m_binding).getType();
            }
            if (this.m_binding instanceof IJstMethod) {
                return ((IJstMethod)this.m_binding).getRtnType();
            }
            if (this.m_binding instanceof IJstType) {
                return (IJstType)this.m_binding;
            }
        }
        return this.m_type;
    }

    @Override
    public String toLHSText() {
        return this.toSimpleTermText();
    }

    @Override
    public IJstType getResultType() {
        return this.getType();
    }

    @Override
    public String toExprText() {
        return this.toSimpleTermText();
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setQualifier(JstIdentifier qualifier) {
        this.removeChild(this.m_qualifier);
        this.addChild(qualifier);
        this.m_qualifier = qualifier;
    }

    public JstIdentifier getQualifier() {
        return this.m_qualifier;
    }

    public JstIdentifier setType(IJstType type) {
        this.m_type = type;
        return this;
    }

    public void setJstBinding(IJstNode binding) {
        this.m_binding = binding;
    }

    public IJstNode getJstBinding() {
        return this.m_binding;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        String s = this.toSimpleTermText();
        return s == null ? "" : s;
    }
}

