/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.stmt.JstStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class PtySetter
extends JstStmt
implements IExpr,
IStmt {
    private static final long serialVersionUID = 1L;
    private final JstIdentifier m_ptyName;
    private IExpr m_qualifyExpr;
    private final String m_ptyValue;

    public PtySetter(String ptyName, String ptyValue, BaseJstNode parent) {
        this(new JstIdentifier(ptyName), ptyValue);
    }

    public PtySetter(JstIdentifier ptyName, String ptyValue) {
        this(ptyName, null, ptyValue);
    }

    public PtySetter(JstIdentifier ptyName, IExpr qualifyExpr, String ptyValue) {
        assert (ptyName != null) : "ptyName cannot be null";
        this.m_ptyName = ptyName;
        this.m_qualifyExpr = qualifyExpr;
        this.m_ptyValue = ptyValue;
        this.addChild(ptyName);
        this.addChild(qualifyExpr);
    }

    @Override
    public IJstType getResultType() {
        return this.m_ptyName == null ? null : this.m_ptyName.getType();
    }

    @Override
    public String toExprText() {
        String text;
        StringBuilder sb = new StringBuilder();
        String q = null;
        if (this.m_qualifyExpr != null) {
            q = this.m_qualifyExpr.toExprText();
        }
        String n = null;
        if (this.m_ptyName != null) {
            n = this.m_ptyName.toSimpleTermText();
        }
        if (q != null) {
            sb.append(q);
        }
        if (q != null && n != null) {
            sb.append(".");
        }
        if (n != null) {
            sb.append(n);
        }
        sb.append("=");
        if (this.m_ptyValue != null) {
            sb.append(this.m_ptyValue);
        }
        return (text = sb.toString()).length() > 0 ? text : null;
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    public JstIdentifier getPtyName() {
        return this.m_ptyName;
    }

    public void setQualifyExpr(IExpr qualifyExpr) {
        this.removeChild(this.m_qualifyExpr);
        this.addChild(qualifyExpr);
        this.m_qualifyExpr = qualifyExpr;
    }

    public IExpr getQualifyExpr() {
        return this.m_qualifyExpr;
    }

    public String getPtyValue() {
        return this.m_ptyValue;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }
}

