/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class BoolExpr
extends ArithExpr
implements IBoolExpr {
    private static final long serialVersionUID = 1L;
    private final IExpr m_left;
    private final IExpr m_right;
    private final Operator m_op;

    public BoolExpr(IExpr left, IExpr right, String op) {
        this(left, right, Operator.toOperator(op));
    }

    public BoolExpr(IExpr left) {
        this(left, (IExpr)null, (Operator)null);
    }

    public BoolExpr(IExpr left, IExpr right, Operator op) {
        assert (left != null) : "left cannot be null";
        this.m_left = left;
        this.m_right = right;
        this.m_op = op;
        this.addChild(left);
        this.addChild(right);
    }

    @Override
    public String toBoolExprText() {
        StringBuilder sb = new StringBuilder();
        if (this.m_left != null) {
            sb.append(this.m_left.toExprText());
        }
        if (this.m_op != null) {
            sb.append(this.m_op.toString());
        }
        if (this.m_right != null) {
            sb.append(this.m_right.toExprText());
        }
        return sb.toString();
    }

    @Override
    public IJstType getResultType() {
        JstType booleanType = JstCache.getInstance().getType("boolean");
        return booleanType;
    }

    @Override
    public String toExprText() {
        return this.toBoolExprText();
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toBoolExprText()) + ";";
    }

    public IExpr getLeft() {
        return this.m_left;
    }

    public IExpr getRight() {
        return this.m_right;
    }

    public Operator getOperator() {
        return this.m_op;
    }

    public String toString() {
        return this.toExprText();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static class Operator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String token;
        public static final Operator LESS = new Operator("<");
        public static final Operator GREATER = new Operator(">");
        public static final Operator LESS_EQUALS = new Operator("<=");
        public static final Operator GREATER_EQUALS = new Operator(">=");
        public static final Operator EQUALS = new Operator("==");
        public static final Operator NOT_EQUALS = new Operator("!=");
        public static final Operator IDENTICAL = new Operator("===");
        public static final Operator NOT_IDENTICAL = new Operator("!==");
        public static final Operator CONDITIONAL_OR = new Operator(" || ");
        public static final Operator CONDITIONAL_AND = new Operator(" && ");
        public static final Operator INSTANCE_OF = new Operator(" " + JsCoreKeywords.INSTANCEOF + " ");
        private static final Map<String, Operator> CODES = new HashMap<String, Operator>(20);

        static {
            Operator[] ops = new Operator[]{LESS, GREATER, LESS_EQUALS, GREATER_EQUALS, EQUALS, NOT_EQUALS, CONDITIONAL_OR, CONDITIONAL_AND, INSTANCE_OF, IDENTICAL, NOT_IDENTICAL};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString().trim(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return CODES.get(token);
        }
    }
}

