/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstParamType
extends JstProxyType {
    private static final long serialVersionUID = 1L;
    private List<IJstType> m_bounds;

    public JstParamType(String name) {
        super(new JstType(name));
        super.getType().getModifiers().setAbstract();
        this.updateType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JstParamType addBound(IJstType bound) {
        if (bound == null) {
            return this;
        }
        JstParamType jstParamType = this;
        synchronized (jstParamType) {
            if (this.m_bounds == null) {
                this.m_bounds = new ArrayList<IJstType>();
            }
            this.m_bounds.add(bound);
            this.updateType();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JstParamType updateBound(String key, IJstType newBound) {
        if (newBound == null || key == null) {
            return this;
        }
        JstParamType jstParamType = this;
        synchronized (jstParamType) {
            if (this.m_bounds != null) {
                boolean update = false;
                int i = 0;
                while (i < this.m_bounds.size()) {
                    IJstType itm = this.m_bounds.get(i);
                    if (key.equals(itm.getName())) {
                        this.m_bounds.set(i, newBound);
                        update = true;
                    }
                    ++i;
                }
                if (update) {
                    this.updateType();
                }
            }
        }
        return this;
    }

    public synchronized List<IJstType> getBounds() {
        if (this.m_bounds == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_bounds);
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.m_bounds != null && !this.m_bounds.isEmpty()) {
            sb.append(" extends ").append(this.m_bounds.get(0).getName());
        }
        return sb.toString();
    }

    private void updateType() {
        JstType target = (JstType)super.getType();
        JstType object = JstCache.getInstance().getType("Object");
        if (object == null) {
            object = JstCache.getInstance().getType("org.eclipse.vjet.dsf.jsnative.global.Object");
        }
        target.clearExtends();
        target.clearSatisfies();
        if (this.m_bounds == null) {
            target.addExtend(object);
        } else {
            boolean hasExtends = false;
            for (IJstType bound : this.m_bounds) {
                if (bound.isInterface()) {
                    target.addSatisfy(bound);
                    continue;
                }
                target.addExtend(bound);
                hasExtends = true;
            }
            if (!hasExtends) {
                target.addExtend(object);
            }
        }
    }
}

