/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public final class JstModifiers
extends BaseJstNode {
    private static final long serialVersionUID = 1L;
    public static final int NONE = 0;
    public static final int PUBLIC = 1;
    public static final int PROTECTED = 4;
    public static final int PRIVATE = 2;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int ABSTRACT = 1024;
    public static final int DYNAMIC = 32;
    private static final String S_PUBLIC = "public";
    private static final String S_PROTECTED = "protected";
    private static final String S_PRIVATE = "private";
    private static final String S_PACKAGE = "";
    private static final String S_PUBLIC_COMMA = "public,";
    private static final String S_PROTECTED_COMMA = "protected,";
    private static final String S_PRIVATE_COMMA = "private,";
    private static final String S_STATIC_COMMA = "static,";
    private static final String S_FINAL_COMMA = "final,";
    private static final String S_ABSTRACT_COMMA = "abstract,";
    private static final String S_DYNAMIC_COMMA = "dynamic,";
    private int m_flags;

    public JstModifiers() {
        this(0);
    }

    public JstModifiers(int flags) {
        this.m_flags = flags;
    }

    public void merge(int flags) {
        this.m_flags |= flags;
    }

    public JstModifiers setPublic() {
        this.m_flags |= 1;
        this.m_flags &= 0xFFFFFFFB;
        this.m_flags &= 0xFFFFFFFD;
        return this;
    }

    public JstModifiers setDefault() {
        this.m_flags &= 0xFFFFFFFE;
        this.m_flags &= 0xFFFFFFFB;
        this.m_flags &= 0xFFFFFFFD;
        return this;
    }

    public boolean isNone() {
        return this.m_flags == 0;
    }

    public boolean isInternal() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isPublic() {
        return (this.m_flags & 1) != 0;
    }

    public JstModifiers setProtected() {
        this.m_flags |= 4;
        this.m_flags &= 0xFFFFFFFE;
        this.m_flags &= 0xFFFFFFFD;
        return this;
    }

    public boolean isProtected() {
        return (this.m_flags & 4) != 0;
    }

    public JstModifiers setPrivate() {
        this.m_flags |= 2;
        this.m_flags &= 0xFFFFFFFE;
        this.m_flags &= 0xFFFFFFFB;
        return this;
    }

    public boolean isPrivate() {
        return (this.m_flags & 2) != 0;
    }

    public JstModifiers setStatic(boolean isTrue) {
        this.m_flags = isTrue ? (this.m_flags |= 8) : (this.m_flags &= 0xFFFFFFF7);
        return this;
    }

    public boolean isStatic() {
        return (this.m_flags & 8) != 0;
    }

    public JstModifiers setFinal() {
        this.setFinal(true);
        return this;
    }

    public JstModifiers setFinal(boolean isTrue) {
        this.m_flags = isTrue ? (this.m_flags |= 0x10) : (this.m_flags &= 0xFFFFFFEF);
        return this;
    }

    public boolean isFinal() {
        return (this.m_flags & 0x10) != 0;
    }

    public JstModifiers setAbstract() {
        this.m_flags |= 0x400;
        return this;
    }

    public JstModifiers setAbstract(boolean isTrue) {
        this.m_flags = isTrue ? (this.m_flags |= 0x400) : (this.m_flags &= 0xFFFFFBFF);
        return this;
    }

    public boolean isAbstract() {
        return (this.m_flags & 0x400) != 0;
    }

    public boolean isDynamic() {
        return (this.m_flags & 0x20) != 0;
    }

    public JstModifiers setDynamic() {
        this.m_flags |= 0x20;
        return this;
    }

    public JstModifiers setDynamic(boolean isTrue) {
        this.m_flags = isTrue ? (this.m_flags |= 0x20) : (this.m_flags &= 0xFFFFFFDF);
        return this;
    }

    public String getAccessScope() {
        if (this.isPublic()) {
            return S_PUBLIC;
        }
        if (this.isProtected()) {
            return S_PROTECTED;
        }
        if (this.isPrivate()) {
            return S_PRIVATE;
        }
        return S_PACKAGE;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (this.isPublic()) {
            sb.append(S_PUBLIC_COMMA);
        }
        if (this.isProtected()) {
            sb.append(S_PROTECTED_COMMA);
        }
        if (this.isPrivate()) {
            sb.append(S_PRIVATE_COMMA);
        }
        if (this.isStatic()) {
            sb.append(S_STATIC_COMMA);
        }
        if (this.isFinal()) {
            sb.append(S_FINAL_COMMA);
        }
        if (this.isAbstract()) {
            sb.append(S_ABSTRACT_COMMA);
        }
        if (this.isDynamic()) {
            sb.append(S_DYNAMIC_COMMA);
        }
        sb.append("]");
        return sb.toString();
    }

    public static int getFlag(String accessScope) {
        int flag = S_PRIVATE.equals(accessScope) ? 2 : (S_PROTECTED.equals(accessScope) ? 4 : (S_PUBLIC.equals(accessScope) ? 1 : 0));
        return flag;
    }

    public JstModifiers getCopy() {
        return new JstModifiers(this.m_flags);
    }

    public void copy(JstModifiers modifiers) {
        this.m_flags = modifiers.m_flags;
    }

    public int getFlags() {
        return this.m_flags;
    }
}

