/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.vjo;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.BaseGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ParenthesizedExpr;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.stmt.BreakStmt;
import org.eclipse.vjet.dsf.jst.stmt.CatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ContinueStmt;
import org.eclipse.vjet.dsf.jst.stmt.DispatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.DoStmt;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForInStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForStmt;
import org.eclipse.vjet.dsf.jst.stmt.IfStmt;
import org.eclipse.vjet.dsf.jst.stmt.LabeledStmt;
import org.eclipse.vjet.dsf.jst.stmt.PtySetter;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThisStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.stmt.TryStmt;
import org.eclipse.vjet.dsf.jst.stmt.TypeDeclStmt;
import org.eclipse.vjet.dsf.jst.stmt.WhileStmt;
import org.eclipse.vjet.dsf.jst.stmt.WithStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.dsf.jst.util.JstMethodHelper;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class StmtGenerator
extends BaseGenerator {
    public StmtGenerator(GeneratorCtx ctx) {
        super(ctx);
    }

    public void writeStmt(IStmt stmt) {
        if (stmt == null) {
            return;
        }
        this.writeComments((IJstNode)stmt);
        if (stmt instanceof AssignExpr) {
            this.write((AssignExpr)stmt);
        } else if (stmt instanceof ArithExpr) {
            this.write((ArithExpr)stmt);
        } else if (stmt instanceof JstVars) {
            this.write((JstVars)stmt);
        } else if (stmt instanceof BreakStmt) {
            this.write((BreakStmt)stmt);
        } else if (stmt instanceof ContinueStmt) {
            this.write((ContinueStmt)stmt);
        } else if (stmt instanceof RtnStmt) {
            this.write((RtnStmt)stmt);
        } else if (stmt instanceof ForStmt) {
            this.write((ForStmt)stmt);
        } else if (stmt instanceof WithStmt) {
            this.write((WithStmt)stmt);
        } else if (stmt instanceof ForInStmt) {
            this.write((ForInStmt)stmt);
        } else if (stmt instanceof DoStmt) {
            this.write((DoStmt)stmt);
        } else if (stmt instanceof WhileStmt) {
            this.write((WhileStmt)stmt);
        } else if (stmt instanceof IfStmt) {
            this.writeNewline();
            this.writeIndent();
            this.write((IfStmt)stmt);
        } else if (stmt instanceof SwitchStmt) {
            this.write((SwitchStmt)stmt);
        } else if (stmt instanceof LabeledStmt) {
            this.write((LabeledStmt)stmt);
        } else if (stmt instanceof ThrowStmt) {
            this.write((ThrowStmt)stmt);
        } else if (stmt instanceof TryStmt) {
            this.write((TryStmt)stmt);
        } else if (stmt instanceof BlockStmt) {
            this.write((BlockStmt)stmt);
        } else if (stmt instanceof ThisStmt) {
            this.write((ThisStmt)stmt);
        } else if (stmt instanceof TypeDeclStmt) {
            this.write((TypeDeclStmt)stmt);
        } else if (stmt instanceof MtdInvocationExpr) {
            this.write((MtdInvocationExpr)stmt);
        } else if (stmt instanceof PtySetter) {
            this.write((PtySetter)stmt);
        } else {
            String text = stmt.toStmtText();
            if (text != null) {
                this.writeNewline();
                this.writeIndent();
                this.getWriter().append(text);
            }
        }
    }

    private void write(AssignExpr stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        if (stmt.getLHS() != null) {
            writer.append(String.valueOf(stmt.getLHS().toLHSText()) + stmt.getOprator().toString());
        }
        this.getExprGenerator().writeExpr(stmt.getExpr());
        writer.append(";");
        this.getCtx().getProvider().getJsDocGenerator().writeJsDoc(stmt, false);
    }

    private void write(ArithExpr arithExpr) {
        this.writeNewline();
        this.writeIndent();
        this.getExprGenerator().writeExpr((IExpr)arithExpr);
        this.getWriter().append(";");
    }

    public void write(JstVars jstVars) {
        this.writeNewline();
        this.writeIndent();
        this.getFragmentGenerator().writeInitializer((IInitializer)jstVars);
        this.getWriter().append(";");
        this.getCtx().getProvider().getJsDocGenerator().writeJsDoc(jstVars);
    }

    private void write(BreakStmt breakStmt) {
        JstIdentifier identifier = breakStmt.getIdentifier();
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append("break");
        if (identifier != null) {
            this.getWriter().append(" ").append(identifier.toSimpleTermText());
        }
        this.getWriter().append(";");
    }

    private void write(ContinueStmt continueStmt) {
        JstIdentifier identifier = continueStmt.getIdentifier();
        this.writeNewline();
        this.writeIndent();
        this.getWriter().append("continue");
        if (identifier != null) {
            this.getWriter().append(" ").append(identifier.toSimpleTermText());
        }
        this.getWriter().append(";");
    }

    private void write(RtnStmt stmt) {
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        writer.append("return");
        IExpr expr = stmt.getExpression();
        if (expr != null) {
            writer.append(" ");
            this.getExprGenerator().writeExpr(expr);
        }
        writer.append(";");
        this.getCtx().getProvider().getJsDocGenerator().writeJsDoc(expr, false);
    }

    private void write(ForStmt stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        IInitializer initializers = stmt.getInitializers();
        IBoolExpr condition = stmt.getCondition();
        List updaters = stmt.getUpdaters();
        JstBlock body = stmt.getBody();
        this.writeNewline();
        this.writeIndent();
        writer.append("for (");
        if (initializers != null) {
            this.getFragmentGenerator().writeInitializer(initializers);
        }
        writer.append(";");
        if (condition != null) {
            writer.append(condition.toBoolExprText());
        }
        writer.append(";");
        int i = 0;
        while (i < updaters.size()) {
            IExpr updater = (IExpr)updaters.get(i);
            this.getExprGenerator().writeExpr(updater);
            if (i < updaters.size() - 1) {
                writer.append(",");
            }
            ++i;
        }
        writer.append(")");
        this.getBodyGenerator().writeBody(body);
    }

    private void write(ForInStmt stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        writer.append(MessageFormat.format("for ({0} in {1})", stmt.getVar().toLHSText(), stmt.getExpr().toExprText()));
        this.getBodyGenerator().writeBody(stmt.getBody());
    }

    private void write(WhileStmt stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        IBoolExpr condition = stmt.getCondition();
        JstBlock body = stmt.getBody();
        this.writeNewline();
        this.writeIndent();
        writer.append("while(");
        if (condition != null) {
            writer.append(condition.toBoolExprText());
        }
        writer.append(")");
        this.getBodyGenerator().writeBody(body);
    }

    private void write(DoStmt stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        IBoolExpr condition = stmt.getCondition();
        JstBlock body = stmt.getBody();
        this.writeNewline();
        this.writeIndent();
        writer.append("do");
        this.getBodyGenerator().writeBody(body);
        writer.append("while(");
        if (condition != null) {
            writer.append(condition.toBoolExprText());
        }
        writer.append(");");
    }

    private void write(IfStmt stmt) {
        if (stmt == null) {
            return;
        }
        if (stmt instanceof DispatchStmt) {
            DispatchStmt dStmt = (DispatchStmt)stmt;
            IJstType extend = dStmt.getOwnerType().getExtend();
            this.constructDispatchStmt(dStmt, VjoConvention.getNameWithStaticThis((String)dStmt.getOwnerType().getSimpleName()), VjoConvention.getThisPrefix(), extend != null && !"vjo.Object".equals(extend.getName()));
        }
        IBoolExpr condition = stmt.getCondition();
        JstBlock thenBlock = stmt.getBody();
        if (condition == null || thenBlock == null) {
            return;
        }
        JstBlock elseIfBlock = stmt.getElseIfBlock(false);
        JstBlock elseBlock = stmt.getElseBlock(false);
        PrintWriter writer = this.getWriter();
        writer.append("if(");
        writer.append(condition.toBoolExprText());
        writer.append(")");
        this.getBodyGenerator().writeBody(thenBlock);
        if (elseIfBlock != null && elseIfBlock.getStmts().size() > 0) {
            for (IStmt eif : elseIfBlock.getStmts()) {
                writer.append("else ");
                this.write((IfStmt)eif);
            }
        }
        if (elseBlock != null) {
            writer.append("else ");
            this.getBodyGenerator().writeBody(elseBlock);
        }
    }

    private void write(SwitchStmt stmt) {
        if (stmt == null) {
            return;
        }
        IExpr expr = stmt.getExpr();
        List stmts = stmt.getBody().getStmts();
        if (expr == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        writer.append("switch(");
        this.getExprGenerator().writeExpr(expr);
        writer.append("){");
        if (stmts != null) {
            this.indent();
            for (IStmt s : stmts) {
                if (s == null) continue;
                if (s instanceof SwitchStmt.CaseStmt) {
                    this.writeNewline();
                    this.writeIndent();
                    writer.append(s.toStmtText());
                    continue;
                }
                if (s instanceof SwitchStmt) {
                    this.indent();
                    this.write((SwitchStmt)s);
                    this.outdent();
                    continue;
                }
                if (s instanceof BlockStmt) {
                    this.writeStmt(s);
                    continue;
                }
                this.indent();
                this.writeNewline();
                this.writeIndent();
                writer.append(s.toStmtText());
                this.outdent();
            }
            this.outdent();
        }
        this.writeNewline();
        this.writeIndent();
        writer.append("}");
    }

    private void write(LabeledStmt stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        writer.append(stmt.getLabel().toSimpleTermText()).append(":");
        this.writeStmt(stmt.getStmt());
    }

    private void write(ThrowStmt stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        writer.append(stmt.toStmtText());
    }

    private void write(TryStmt stmt) {
        JstBlock fBlock;
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        writer.append("try ");
        this.getBodyGenerator().writeBody(stmt.getBody());
        if (stmt.getCatchBlock(false) != null) {
            for (IStmt c : stmt.getCatchBlock(false).getStmts()) {
                this.write((CatchStmt)c);
            }
        }
        if ((fBlock = stmt.getFinallyBlock(false)) != null) {
            this.writeNewline();
            this.writeIndent();
            writer.append("finally ");
            this.getBodyGenerator().writeBody(fBlock);
        }
    }

    private void write(BlockStmt stmt) {
        if (stmt == null) {
            return;
        }
        this.writeNewline();
        this.writeIndent();
        this.getBodyGenerator().writeBody(stmt.getBody());
    }

    private void write(CatchStmt stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        writer.append("catch(").append(stmt.getException().getName()).append(")");
        this.getBodyGenerator().writeBody(stmt.getBody());
    }

    private void write(TypeDeclStmt stmt) {
        if (stmt == null) {
            return;
        }
        JstType localType = stmt.getType();
        if (localType != null) {
            VjoGenerator typeGenerator = this.getTypeGenerator();
            this.writeNewline();
            this.writeIndent();
            IJstType previousType = typeGenerator.getCurrentType();
            typeGenerator.writeVjo((IJstType)localType);
            typeGenerator.setCurrentType(previousType);
        }
    }

    private void write(ThisStmt stmt) {
        PrintWriter writer = this.getWriter();
        this.writeNewline();
        this.writeIndent();
        writer.append(stmt.toStmtText());
    }

    private void write(PtySetter setter) {
        this.writeNewline();
        this.writeIndent();
        this.getExprGenerator().writeExpr((IExpr)setter);
        this.getWriter().append(";");
    }

    private void write(MtdInvocationExpr mtdInvocation) {
        this.writeNewline();
        this.writeIndent();
        this.getExprGenerator().writeExpr((IExpr)mtdInvocation);
        this.getWriter().append(";");
    }

    private void write(WithStmt stmt) {
        if (stmt == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        BoolExpr condition = stmt.getCondition();
        JstBlock body = stmt.getBody();
        this.writeNewline();
        this.writeIndent();
        writer.append("with (");
        if (condition != null) {
            writer.append(condition.toBoolExprText());
        }
        writer.append(")");
        this.getBodyGenerator().writeBody(body);
    }

    private void constructDispatchStmt(DispatchStmt dispatchStmt, String staticQualifier, String instanceQualifier, boolean hasSuperClass) {
        Map mtds = dispatchStmt.getMethods();
        if (mtds.size() == 0) {
            return;
        }
        BaseJstNode meth = dispatchStmt.getParentNode();
        while (meth != null && !(meth instanceof IJstMethod)) {
            meth = meth.getParentNode();
        }
        boolean hasReturn = false;
        if (meth != null && meth instanceof IJstMethod) {
            IJstType type = ((IJstMethod)meth).getRtnType();
            hasReturn = type != null && !"void".equalsIgnoreCase(type.getName());
        }
        String mtdName = null;
        boolean isConstructor = false;
        boolean isStatic = false;
        for (Map.Entry entry : mtds.entrySet()) {
            Integer key = (Integer)entry.getKey();
            BoolExpr cond = new BoolExpr((IExpr)new TextExpr("arguments.length"), (IExpr)new TextExpr(key.toString()), BoolExpr.Operator.IDENTICAL);
            List list = (List)entry.getValue();
            if (list.size() > 1) {
                Collections.sort(list, JstMethodHelper.s_mtdComparator);
            }
            JstMethod first = (JstMethod)list.get(0);
            isConstructor = first.isConstructor();
            isStatic = first.isStatic();
            mtdName = first.getOriginalName();
            if (list.size() == 1 && (!hasSuperClass || isConstructor)) {
                JstMethod jstMtd = (JstMethod)list.get(0);
                IJstType rtnType = jstMtd.getRtnType();
                String qualifier = jstMtd.isStatic() ? staticQualifier : instanceQualifier;
                MtdInvocationExpr mtdInvocation = new MtdInvocationExpr(String.valueOf(qualifier) + "." + jstMtd.getName(), new IExpr[0]);
                List args = jstMtd.getArgs();
                int i = 0;
                while (i < args.size()) {
                    mtdInvocation.addArg((IExpr)new TextExpr("arguments[" + i + "]"));
                    ++i;
                }
                RtnStmt addReturn = new RtnStmt((IExpr)mtdInvocation);
                if (dispatchStmt.getCondition() == null) {
                    dispatchStmt.setCondition((IBoolExpr)cond);
                    if (rtnType == null || "void".equalsIgnoreCase(rtnType.getName())) {
                        dispatchStmt.getBody().addStmt((IStmt)mtdInvocation);
                    } else {
                        dispatchStmt.getBody().addStmt((IStmt)addReturn);
                    }
                } else {
                    IfStmt elseIf = new IfStmt();
                    dispatchStmt.addChild((IJstNode)elseIf);
                    elseIf.setCondition((IBoolExpr)cond);
                    if (rtnType == null || "void".equalsIgnoreCase(rtnType.getName())) {
                        elseIf.getBody().addStmt((IStmt)mtdInvocation);
                    } else {
                        elseIf.getBody().addStmt((IStmt)addReturn);
                    }
                    dispatchStmt.addElseStmt(elseIf);
                }
                if (mtdName == null || jstMtd.isStatic() || jstMtd.isConstructor() || !hasSuperClass) continue;
                this.addBaseDispatch((IfStmt)dispatchStmt, mtdName, hasReturn);
                continue;
            }
            IfStmt innerIf = new IfStmt();
            dispatchStmt.getBody().addChild((IJstNode)innerIf);
            if (dispatchStmt.getCondition() == null) {
                dispatchStmt.setCondition((IBoolExpr)cond);
                dispatchStmt.getBody().addStmt((IStmt)innerIf);
            } else {
                IfStmt elseIf = new IfStmt();
                dispatchStmt.addChild((IJstNode)elseIf);
                elseIf.setCondition((IBoolExpr)cond);
                elseIf.getBody().addStmt((IStmt)innerIf);
                dispatchStmt.addElseStmt(elseIf);
                innerIf.setParent((IJstNode)elseIf);
            }
            ArrayList<JstMethod> list1 = new ArrayList<JstMethod>();
            ArrayList<JstMethod> list2 = new ArrayList<JstMethod>();
            for (JstMethod jstMtd : list) {
                if (this.hasParamArg(jstMtd)) {
                    list2.add(jstMtd);
                    continue;
                }
                list1.add(jstMtd);
            }
            this.processMethod(dispatchStmt, key, list1, innerIf, staticQualifier, instanceQualifier);
            this.processMethod(dispatchStmt, key, list2, innerIf, staticQualifier, instanceQualifier);
            if (mtdName == null || isStatic || isConstructor || !hasSuperClass) continue;
            this.addBaseDispatch(innerIf, mtdName, hasReturn);
        }
        if (mtdName != null && !isStatic && !isConstructor && hasSuperClass) {
            this.addBaseDispatch((IfStmt)dispatchStmt, mtdName, hasReturn);
        }
    }

    private void addBaseDispatch(IfStmt dispatchStmt, String mtdName, boolean hasReturn) {
        IfStmt defaultBlock = new IfStmt();
        String baseMeth = "this.base";
        baseMeth = String.valueOf(baseMeth) + "." + mtdName;
        defaultBlock.setCondition((IBoolExpr)new BoolExpr((IExpr)new TextExpr("this.base"), (IExpr)new TextExpr(baseMeth), BoolExpr.Operator.CONDITIONAL_AND));
        String baseCall = String.valueOf(baseMeth) + ".apply(this,arguments)";
        if (hasReturn) {
            baseCall = "return " + baseCall;
        }
        defaultBlock.getBody().addStmt((IStmt)new ExprStmt((IExpr)new TextExpr(baseCall)));
        dispatchStmt.addElseStmt(defaultBlock);
    }

    private boolean hasParamArg(JstMethod jstMtd) {
        for (JstArg arg : jstMtd.getArgs()) {
            if (!(arg.getType() instanceof JstParamType)) continue;
            return true;
        }
        return false;
    }

    private void processMethod(DispatchStmt dispatchStmt, Integer numOfArgs, List<JstMethod> list, IfStmt innerIf, String staticQualifier, String instanceQualifier) {
        for (JstMethod jstMtd : list) {
            IJstType rtnType = jstMtd.getRtnType();
            String qualifier = jstMtd.isStatic() ? staticQualifier : instanceQualifier;
            MtdInvocationExpr mtdInvocation = new MtdInvocationExpr(String.valueOf(qualifier) + "." + jstMtd.getName(), new IExpr[0]);
            List args = jstMtd.getArgs();
            BoolExpr innerCond = new BoolExpr((IExpr)new TextExpr("arguments.length"), (IExpr)new TextExpr(numOfArgs.toString()), BoolExpr.Operator.EQUALS);
            int i = 0;
            while (i < args.size()) {
                if (args.get(i) != null && ((JstArg)args.get(i)).getType() != null) {
                    String argStr = "arguments[" + i + "]";
                    mtdInvocation.addArg((IExpr)new TextExpr(argStr));
                    MtdInvocationExpr mtdExpr = this.createInstanceOfMethod(args, ((JstArg)args.get(i)).getType(), argStr);
                    BoolExpr cond = mtdExpr != null ? new BoolExpr((IExpr)mtdExpr) : this.createCond(((JstArg)args.get(i)).getType(), argStr, ((JstArg)args.get(i)).isVariable(), i);
                    if (i == 0) {
                        innerCond = cond;
                    } else {
                        BoolExpr e1 = innerCond;
                        if (innerCond.getOperator() == BoolExpr.Operator.CONDITIONAL_OR) {
                            e1 = new ParenthesizedExpr((IExpr)innerCond);
                        }
                        BoolExpr e2 = cond;
                        if (cond.getOperator() == BoolExpr.Operator.CONDITIONAL_OR) {
                            e2 = new ParenthesizedExpr((IExpr)cond);
                        }
                        innerCond = new BoolExpr((IExpr)e1, (IExpr)e2, BoolExpr.Operator.CONDITIONAL_AND);
                    }
                }
                ++i;
            }
            RtnStmt addReturn = new RtnStmt((IExpr)mtdInvocation);
            if (innerIf.getCondition() == null) {
                innerIf.setCondition((IBoolExpr)innerCond);
                if (rtnType == null || "void".equalsIgnoreCase(rtnType.getName())) {
                    innerIf.getBody().addStmt((IStmt)mtdInvocation);
                    continue;
                }
                innerIf.getBody().addStmt((IStmt)addReturn);
                continue;
            }
            IfStmt elseIf = new IfStmt();
            dispatchStmt.addChild((IJstNode)elseIf);
            elseIf.setCondition((IBoolExpr)innerCond);
            if (rtnType == null || "void".equalsIgnoreCase(rtnType.getName())) {
                elseIf.getBody().addStmt((IStmt)mtdInvocation);
            } else {
                elseIf.getBody().addStmt((IStmt)addReturn);
            }
            innerIf.addElseStmt(elseIf);
        }
    }

    private MtdInvocationExpr createInstanceOfMethod(List<JstArg> args, IJstType argType, String argExprText) {
        if (DataTypeHelper.isPrimitiveType((IJstType)argType) || DataTypeHelper.getNativeType((String)argType.getName()) != null || argType instanceof JstArray || DataTypeHelper.isString((IJstType)argType) || argType instanceof JstParamType || argType.getName().equals("boolean") || !argType.isInterface()) {
            return null;
        }
        String typeName = DataTypeHelper.getTypeName((String)argType.getName());
        return new MtdInvocationExpr(new JstIdentifier("isInstance", new JstIdentifier(String.valueOf(typeName) + ".clazz")), new IExpr[]{new TextExpr(argExprText)});
    }

    private BoolExpr createCond(IJstType type, String arg, boolean isVarArg, int index) {
        BoolExpr cond = null;
        if (isVarArg || type instanceof JstArray) {
            cond = new BoolExpr((IExpr)new TextExpr(arg), (IExpr)new TextExpr("Array"), BoolExpr.Operator.INSTANCE_OF);
        } else if (DataTypeHelper.isNumericPrimitiveType((IJstType)type) || DataTypeHelper.isCharPrimitiveType((IJstType)type)) {
            cond = new BoolExpr((IExpr)new TextExpr("typeof " + arg), (IExpr)new TextExpr("\"number\""), BoolExpr.Operator.EQUALS);
        } else if (type.getName().equals("boolean")) {
            cond = new BoolExpr((IExpr)new TextExpr("typeof " + arg), (IExpr)new TextExpr("\"boolean\""), BoolExpr.Operator.EQUALS);
        } else if (DataTypeHelper.isString((IJstType)type)) {
            BoolExpr left = new BoolExpr((IExpr)new TextExpr(arg), (IExpr)new TextExpr("String"), BoolExpr.Operator.INSTANCE_OF);
            BoolExpr right = new BoolExpr((IExpr)new TextExpr("typeof " + arg), (IExpr)new TextExpr("\"string\""), BoolExpr.Operator.EQUALS);
            cond = new BoolExpr((IExpr)left, (IExpr)right, BoolExpr.Operator.CONDITIONAL_OR);
        } else {
            cond = type instanceof JstParamType ? new BoolExpr((IExpr)new TextExpr(arg), (IExpr)new TextExpr("Object"), BoolExpr.Operator.INSTANCE_OF) : new BoolExpr((IExpr)new TextExpr(arg), (IExpr)new TextExpr(DataTypeHelper.getTypeName((String)type.getName())), BoolExpr.Operator.INSTANCE_OF);
        }
        return cond;
    }
}

