/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util;

import java.util.Set;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationDriver;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoScope;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.ThisKeywordUtil;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;

public class VjoValidationVisitorCtxUpdateUtil {
    public static void updateCtxBeforeType(VjoValidationCtx ctx, IJstType node) {
        ctx.getScope().addTypeNode(node);
        ctx.getScope().addScopeNode((IJstNode)node);
        if (ctx.getMakeParentType(node) != null) {
            ctx.setDependencyVerifier(node, new VjoValidationDriver.VjoDependencyVerifierDecorator(ctx.getDependencyVerifier(ctx.getMakeParentType(node))));
        }
        if (node.getOuterType() != null) {
            ctx.setDependencyVerifier(node, new VjoValidationDriver.VjoDependencyVerifierDecorator(ctx.getDependencyVerifier(ctx.getTypeSpaceType(node.getOuterType()))));
        }
        ThisKeywordUtil.supportThis(ctx, (IJstNode)node, true);
    }

    public static void updateCtxAfterType(VjoValidationCtx ctx, IJstType node) {
        ctx.getScope().removeScopeNode((IJstNode)node);
        ctx.getScope().removeTypeNode(node);
    }

    public static void updateCtxBeforeObjLiteral(VjoValidationCtx ctx, ObjLiteral node) {
        IJstType makeType = ctx.getMakeTypeByObjLiteral(node);
        if (makeType != null) {
            return;
        }
        JstObjectLiteralType typeScope = new JstObjectLiteralType("ObjLiteral");
        ctx.getScope().addTypeNode((IJstType)typeScope);
        ctx.getScope().addScopeNode((IJstNode)typeScope);
    }

    public static void updateCtxAfterObjLiteral(VjoValidationCtx ctx, ObjLiteral node) {
        IJstType makeType = ctx.getMakeTypeByObjLiteral(node);
        if (makeType != null) {
            return;
        }
        IJstType typeScope = ctx.getScope().getClosestTypeScopeNode();
        ctx.getScope().removeScopeNode((IJstNode)typeScope);
        ctx.getScope().removeTypeNode(typeScope);
    }

    public static void updateCtxBeforeMethod(VjoValidationCtx ctx, JstMethod node) {
        ctx.getScope().addScopeNode((IJstNode)node);
        VjoScope ctxScope = ctx.getScope();
        if (node.isStatic()) {
            ctxScope.setStatic(true);
        } else {
            ctxScope.setStatic(false);
            ThisKeywordUtil.supportThis(ctx, (IJstNode)node, false);
        }
    }

    public static void updateCtxBeforeProperty(VjoValidationCtx ctx, JstProperty node) {
        if (!node.isStatic()) {
            ctx.getScope().addScopeNode((IJstNode)node);
            ctx.getScope().setStatic(false);
            ThisKeywordUtil.supportThis(ctx, (IJstNode)node, node.isStatic());
        }
        JstType ownerType = node.getOwnerType();
        Set<IJstType> unintializedTypes = ctx.getDependencyVerifier((IJstType)ownerType).getDirectDependenciesFilteredByGroup((IJstType)ownerType);
        for (IJstType uninitializedType : unintializedTypes) {
            ctx.addUnintializedType(uninitializedType);
        }
    }

    public static void updateCtxAfterProperty(VjoValidationCtx ctx, JstProperty node) {
        if (!node.isStatic()) {
            ThisKeywordUtil.unsupportThis(ctx, (IJstNode)node, node.isStatic());
            ctx.getScope().removeScopeNode((IJstNode)node);
            ctx.getSymbolTable().removeSymbolsInScope((IJstNode)node);
        }
        JstType ownerType = node.getOwnerType();
        Set<IJstType> unintializedTypes = ctx.getDependencyVerifier((IJstType)ownerType).getDirectDependenciesFilteredByGroup((IJstType)ownerType);
        for (IJstType uninitializedType : unintializedTypes) {
            ctx.removeUnintializedType(uninitializedType);
        }
    }

    public static void updateCtxAfterMethod(VjoValidationCtx ctx, JstMethod node) {
        if (!node.isStatic()) {
            ThisKeywordUtil.unsupportThis(ctx, (IJstNode)node, false);
        }
        ctx.getScope().removeScopeNode((IJstNode)node);
        ctx.getSymbolTable().removeSymbolsInScope((IJstNode)node);
    }
}

