/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util;

import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.EVjoSymbolType;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.IVjoSymbol;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbol;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbolTable;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;

public class JstSymbolReplicateUtil {
    public static void replicate(VjoValidationCtx ctx, IJstType fromType, IJstType toType) {
        JstSymbolReplicateUtil.replicate(ctx, fromType, toType, EVjoSymbolType.LOCAL_VARIABLE);
        JstSymbolReplicateUtil.replicate(ctx, fromType, toType, EVjoSymbolType.INSTANCE_VARIABLE);
        JstSymbolReplicateUtil.replicate(ctx, fromType, toType, EVjoSymbolType.STATIC_VARIABLE);
    }

    public static void replicate(VjoValidationCtx ctx, IJstType fromType, IJstType toType, EVjoSymbolType symbolType) {
        VjoSymbolTable symbolTable = ctx.getSymbolTable();
        List<IVjoSymbol> symbols2Replicate = symbolTable.getSymbolsInScope((IJstNode)fromType, symbolType);
        for (IVjoSymbol symbol2Replicate : symbols2Replicate) {
            IVjoSymbol symbolReplicated;
            if (symbols2Replicate == null || (symbolReplicated = symbolTable.getSymbolInScope((IJstNode)toType, symbol2Replicate.getName(), symbol2Replicate.getSymbolType())) != null) continue;
            symbolReplicated = new VjoSymbol();
            symbolReplicated.setName(symbol2Replicate.getName());
            symbolReplicated.setDeclareType(symbol2Replicate.getDeclareType());
            symbolReplicated.setSymbolType(symbol2Replicate.getSymbolType());
            symbolReplicated.setDeclareNode(symbol2Replicate.getDeclareNode());
            symbolReplicated.setAssignedType(symbol2Replicate.getAssignedType());
            symbolReplicated.setStaticReference(symbol2Replicate.isStaticReference());
            symbolReplicated.setVisible(symbol2Replicate.isVisible());
            symbolTable.addSymbolInScope((IJstNode)toType, symbolReplicated);
        }
    }

    public static void replicateAndModify(VjoValidationCtx ctx, IJstType fromType, IJstType toType, EVjoSymbolType symbolType, EVjoSymbolType modifiedSymbolType) {
        VjoSymbolTable symbolTable = ctx.getSymbolTable();
        List<IVjoSymbol> symbols2Replicate = symbolTable.getSymbolsInScope((IJstNode)fromType, symbolType);
        for (IVjoSymbol symbol2Replicate : symbols2Replicate) {
            IVjoSymbol symbolReplicated;
            if (symbols2Replicate == null || (symbolReplicated = symbolTable.getSymbolInScope((IJstNode)toType, symbol2Replicate.getName(), modifiedSymbolType)) != null) continue;
            symbolReplicated = new VjoSymbol();
            symbolReplicated.setName(symbol2Replicate.getName());
            symbolReplicated.setDeclareType(symbol2Replicate.getDeclareType());
            symbolReplicated.setSymbolType(modifiedSymbolType);
            symbolReplicated.setDeclareNode(symbol2Replicate.getDeclareNode());
            symbolReplicated.setAssignedType(symbol2Replicate.getAssignedType());
            symbolReplicated.setStaticReference(symbol2Replicate.isStaticReference());
            symbolReplicated.setVisible(symbol2Replicate.isVisible());
            symbolTable.addSymbolInScope((IJstNode)toType, symbolReplicated);
        }
    }
}

