/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules;

import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblemFactory;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoMethodControlFlowTable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.MethodAndReturnFlowRuleCtx;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class VoidMethodShouldNotHaveReturnRule
extends VjoSemanticRule<MethodAndReturnFlowRuleCtx> {
    @Override
    public VjoSemanticProblem doFire(MethodAndReturnFlowRuleCtx ctx) {
        IJstMethod method = ctx.getMethod();
        VjoMethodControlFlowTable flowTable = ctx.getReturnFlowTable();
        if (method != null && flowTable != null && method.getRtnType() != null && "void".equals(method.getRtnType().getSimpleName())) {
            List<IStmt> stmts = flowTable.lookUpStmt((IJstMethod)((JstMethod)method));
            boolean returnFound = false;
            for (IStmt stmt : stmts) {
                if (stmt == null) continue;
                if (stmt instanceof ThrowStmt && ((ThrowStmt)stmt).getExpression() != null) {
                    returnFound = true;
                    break;
                }
                if (!(stmt instanceof RtnStmt) || ((RtnStmt)stmt).getExpression() == null) continue;
                returnFound = true;
                break;
            }
            if (returnFound) {
                VjoSemanticProblem problem = VjoSemanticProblemFactory.getInstance().createProblem(ctx.getArguments(), ctx.getGroupId(), this.getProblemId(), this.getErrMsg(), ctx.getNode(), this);
                return problem;
            }
        }
        return null;
    }
}

