/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jst.IJstType;

public class VjoValidationResult {
    private Map<IJstType, List<VjoSemanticProblem>> m_problems;

    public void addResult(IJstType type, List<VjoSemanticProblem> problems) {
        List<VjoSemanticProblem> probList;
        if (this.m_problems == null) {
            this.m_problems = new HashMap<IJstType, List<VjoSemanticProblem>>();
        }
        if ((probList = this.m_problems.get(type)) == null) {
            probList = new ArrayList<VjoSemanticProblem>();
            this.m_problems.put(type, probList);
        }
        probList.addAll(problems);
    }

    public List<VjoSemanticProblem> getProblemsByType(IJstType type) {
        if (this.m_problems == null) {
            return Collections.emptyList();
        }
        List<VjoSemanticProblem> toReturn = this.m_problems.get(type);
        if (toReturn == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(toReturn);
    }

    public List<VjoSemanticProblem> getAllProblems() {
        return this.getAllProblems(-1);
    }

    public List<VjoSemanticProblem> getAllProblems(int limit) {
        if (this.m_problems == null) {
            return Collections.emptyList();
        }
        ArrayList<VjoSemanticProblem> toReturn = new ArrayList<VjoSemanticProblem>();
        for (List<VjoSemanticProblem> typeProblems : this.m_problems.values()) {
            int actualLimit = limit >= 0 ? Math.min(typeProblems.size(), limit) : typeProblems.size();
            int i = 0;
            while (i < actualLimit) {
                toReturn.add(typeProblems.get(i));
                ++i;
            }
        }
        return toReturn;
    }
}

