/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo;

import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.util.JstDisplayUtils;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoDependencyVerifiable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoGroupRulesCache;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRulePolicy;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoConstants;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.AccessControlUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.VjoValidationVisitorState;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstDeferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVariantType;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.declaration.SynthOlType;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public abstract class VjoSemanticValidator
implements IVjoValidationListener {
    protected boolean isJavaKeyword(String name) {
        String[] arr = new String[VjoConstants.JAVA_ONLY_KEYWORDS.size()];
        return this.isKeyword(name, VjoConstants.JAVA_ONLY_KEYWORDS.toArray(arr));
    }

    protected boolean isVjoKeyword(String name, List<String> keywords) {
        String[] arr = new String[keywords.size()];
        return this.isKeyword(name, keywords.toArray(arr));
    }

    protected boolean isVjoKeyword(String name, String[] keywords) {
        return this.isKeyword(name, keywords);
    }

    protected JstMethod lookUpMethod(IJstNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof JstType) {
            return null;
        }
        if (node instanceof JstMethod) {
            return (JstMethod)node;
        }
        return this.lookUpMethod(node.getParentNode());
    }

    private boolean isKeyword(String name, String[] keywords) {
        if (name.startsWith("\"") && name.endsWith("\"") || name.startsWith("'") && name.endsWith("'")) {
            return false;
        }
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String vjoKeyword = stringArray[n2];
            if (vjoKeyword.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected VjoSemanticValidator() {
    }

    protected IJstType getTargetType(IJstType jstType) {
        if (jstType != null && jstType instanceof JstProxyType) {
            return ((JstProxyType)jstType).getType();
        }
        return jstType;
    }

    protected IJstType getKnownType(VjoValidationCtx ctx, IJstType targetType, IJstType unknownType) {
        List paramTypeList;
        String unknownGroupName;
        if (targetType == null || unknownType == null) {
            return VjoConstants.ARBITARY;
        }
        if (unknownType instanceof JstParamType) {
            return VjoConstants.ARBITARY;
        }
        if (unknownType instanceof IJstRefType) {
            unknownType = ((IJstRefType)unknownType).getReferencedNode();
        }
        if (unknownType instanceof JstArray) {
            return unknownType;
        }
        JstPackage jstPackage = unknownType.getPackage();
        if (jstPackage != null && jstPackage.getGroupName().length() > 0) {
            return VjoConstants.ARBITARY;
        }
        IJstType typeSpacedUnknownType = ctx.getTypeSpaceType(unknownType);
        JstPackage unknownPackage = typeSpacedUnknownType.getPackage();
        if (unknownPackage != null && ("JavaPrimitive".equals(unknownGroupName = unknownPackage.getGroupName()) || "JsNativeGlobal".equals(unknownGroupName) || "JsNativeLib".equals(unknownGroupName) || "VjoBaseLib".equals(unknownGroupName) || "VjoJavaLib".equals(unknownGroupName))) {
            return typeSpacedUnknownType;
        }
        if ("Object".equals(typeSpacedUnknownType.getSimpleName())) {
            return typeSpacedUnknownType;
        }
        if (unknownType != null && unknownType instanceof JstObjectLiteralType) {
            return unknownType;
        }
        String unknownTypeName = unknownPackage != null && "this.vj$".equals(unknownPackage.getName()) ? unknownType.getSimpleName() : unknownType.getName();
        for (IJstType depType : ctx.getDependencyVerifier(targetType).getDirectDependenciesFilteredByGroup(targetType)) {
            if (depType == null || depType.getSimpleName() == null) continue;
            if (depType.getName().equals(unknownTypeName)) {
                return depType;
            }
            if (!depType.getSimpleName().equals(unknownTypeName)) continue;
            return depType;
        }
        List secondaryTypes = targetType.getSecondaryTypes();
        if (secondaryTypes != null && !secondaryTypes.isEmpty()) {
            String typeName = unknownTypeName;
            if (unknownType instanceof JstAttributedType) {
                JstAttributedType atype = (JstAttributedType)unknownType;
                typeName = atype.getAttributorType().getName();
            }
            for (IJstType secondaryType : secondaryTypes) {
                if (!secondaryType.getName().equals(typeName)) continue;
                return secondaryType;
            }
        }
        if ((paramTypeList = targetType.getParamTypes()) != null && !paramTypeList.isEmpty()) {
            for (JstParamType paramType : paramTypeList) {
                if (!paramType.getSimpleName().equals(unknownTypeName)) continue;
                return paramType;
            }
        }
        return null;
    }

    public <Ctx extends IVjoSemanticRuleCtx> boolean satisfyRule(VjoValidationCtx ctx, IVjoSemanticRule<Ctx> rule, Ctx ruleCtx) throws VjoValidationRuntimeException {
        ruleCtx.setMode(ctx.getValidationMode());
        VjoSemanticProblem problem = rule.fire(ruleCtx);
        if (problem == null) {
            return true;
        }
        ctx.addProblem(ruleCtx.getNode(), problem);
        VjoSemanticRulePolicy policy = VjoGroupRulesCache.getInstance().getRulePolicy(ctx.getGroupId(), rule);
        if (policy.stopOnFirstError()) {
            throw new VjoValidationRuntimeException(problem.toString());
        }
        return false;
    }

    @Override
    public abstract List<Class<? extends IJstNode>> getTargetNodeTypes();

    protected void onPreAllChildrenEvent(IVjoValidationVisitorEvent event) {
    }

    protected void onPreChildEvent(IVjoValidationVisitorEvent event) {
    }

    protected void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
    }

    protected void onPostChildEvent(IVjoValidationVisitorEvent event) {
    }

    @Override
    public void onEvent(IVjoValidationVisitorEvent event) {
        if (VjoValidationVisitorState.BEFORE_ALL_CHILDREN.equals((Object)event.getVisitState())) {
            this.onPreAllChildrenEvent(event);
        } else if (VjoValidationVisitorState.BEFORE_CHILD.equals((Object)event.getVisitState())) {
            this.onPreChildEvent(event);
        } else if (VjoValidationVisitorState.AFTER_CHILD.equals((Object)event.getVisitState())) {
            this.onPostChildEvent(event);
        } else if (VjoValidationVisitorState.AFTER_ALL_CHILDREN.equals((Object)event.getVisitState())) {
            this.onPostAllChildrenEvent(event);
        }
    }

    protected void checkAndReportMissingParamTypeUpperBound(IJstType ownerType, VjoValidationCtx ctx, List<JstParamType> listParamTypes) {
        for (JstParamType paramType : listParamTypes) {
            List bounds = paramType.getBounds();
            if (bounds == null || bounds.isEmpty()) continue;
            IJstType upperBound = (IJstType)bounds.get(0);
            this.checkAndReportMissingImportProblem(ownerType, (IJstNode)ownerType, ctx, upperBound);
        }
    }

    protected boolean checkAndReportMissingImportProblem(IJstType ownerType, IJstNode node, VjoValidationCtx ctx, IJstType targetType) {
        if (targetType instanceof IInferred) {
            return false;
        }
        IJstType knownType = this.getKnownType(ctx, ownerType, targetType);
        if (ownerType != null && knownType == null && targetType.getPackage() == null && !"ERROR_UNDEFINED_TYPE".equals(targetType.getSimpleName()) && targetType.getPackage() == null) {
            if (!ctx.getMissingImportTypes().contains(targetType)) {
                ctx.addMissingImportType(targetType);
            }
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx(node, ctx.getGroupId(), new String[]{targetType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().UNKNOWN_TYPE_MISSING_IMPORT, ruleCtx);
            return true;
        }
        return false;
    }

    protected void validateComplexType(VjoValidationCtx ctx, IJstNode jstNode, String display, IJstType type) {
        if (type == null) {
            return;
        }
        if (type instanceof JstArray) {
            this.validateComplexType(ctx, jstNode, display, ((JstArray)type).getComponentType());
        } else if (type instanceof JstAttributedType) {
            this.validateAttributedType(ctx, jstNode, display, (JstAttributedType)type);
        } else if (type instanceof JstVariantType) {
            this.validateVariantType(ctx, jstNode, display, (JstVariantType)type);
        } else if (type instanceof JstMixedType) {
            this.validateMixedType(ctx, jstNode, display, (JstMixedType)type);
        } else if (type instanceof JstTypeWithArgs) {
            this.validateJstWithArgs(jstNode.getOwnerType(), jstNode, display, ctx, (JstTypeWithArgs)type);
        } else if (type instanceof JstWildcardType) {
            this.validateComplexType(ctx, jstNode, display, ((JstWildcardType)type).getType());
        } else if (type instanceof IJstRefType) {
            this.validateComplexType(ctx, jstNode, display, ((IJstRefType)type).getReferencedNode());
        } else if (type instanceof JstFuncType) {
            JstFuncType declaredFuncType = (JstFuncType)type;
            IJstMethod declaredMethod = declaredFuncType.getFunction();
            if (declaredMethod != null) {
                this.validateComplexType(ctx, jstNode, declaredMethod.getName().getName(), declaredMethod.getRtnType());
                for (JstArg arg : declaredMethod.getArgs()) {
                    this.validateComplexType(ctx, (IJstNode)arg, arg.getName(), arg.getType());
                }
            }
        } else if (type instanceof JstDeferredType) {
            JstDeferredType deferredType = (JstDeferredType)type;
            IJstType resolvedType = deferredType.getResolvedType();
            if (resolvedType != null) {
                this.validateJstDeferredType(ctx, jstNode, deferredType, resolvedType);
            }
        } else if (type instanceof SynthOlType) {
            SynthOlType synthOlType = (SynthOlType)type;
            if (synthOlType.getResolvedOTypes() != null) {
                for (IJstType resolvedOType : synthOlType.getResolvedOTypes()) {
                    if (resolvedOType == null || !this.isOType(resolvedOType)) continue;
                    this.validateSynthOlType(ctx, jstNode, synthOlType, (JstObjectLiteralType)resolvedOType);
                }
            }
        } else {
            this.validateUnknownTypes(ctx, jstNode, type);
        }
    }

    private boolean isOType(IJstType resolvedOType) {
        return resolvedOType instanceof JstObjectLiteralType;
    }

    private void validateUnknownTypes(VjoValidationCtx ctx, IJstNode jstNode, IJstType type) {
        IJstType ownerType;
        VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
        IJstType iJstType = ownerType = jstNode.getOwnerType() != null ? jstNode.getOwnerType() : ctx.getJstNode().getOwnerType();
        if (ownerType != null) {
            IJstType knownType = this.getKnownType(ctx, ownerType, type);
            if (!(ownerType == null || knownType != null || "ERROR_UNDEFINED_TYPE".equals(type.getSimpleName()) || "?".equals(type.getSimpleName()) || ctx.getUnresolvedTypes().contains(type.getName()))) {
                if (!ctx.getMissingImportTypes().contains(type)) {
                    ctx.addMissingImportType(type);
                }
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{type.getName()});
                this.satisfyRule(ctx, ruleRepo.UNKNOWN_TYPE_MISSING_IMPORT, ruleCtx);
            }
        }
    }

    private void validateJstDeferredType(VjoValidationCtx ctx, IJstNode jstNode, JstDeferredType deferredType, IJstType resolvedType) {
        boolean satisfied = false;
        StringBuilder candidates = new StringBuilder().append('{');
        for (IJstType candidateType : deferredType.getCandidateTypes()) {
            if (this.satisifies(resolvedType, candidateType)) {
                satisfied = true;
                continue;
            }
            candidates.append(candidateType.getName()).append(',');
        }
        if (!satisfied) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{resolvedType.getName(), candidates.append('}').toString(), resolvedType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ASSIGNABLE, ruleCtx);
        }
    }

    private boolean satisifies(IJstType resolvedType, IJstType candidateType) {
        if (candidateType == null) {
            return true;
        }
        if (candidateType instanceof JstDeferredType) {
            for (IJstType recursiveCandidateType : ((JstDeferredType)candidateType).getCandidateTypes()) {
                if (!this.satisifies(resolvedType, recursiveCandidateType)) continue;
                return true;
            }
            return false;
        }
        return TypeCheckUtil.isAssignable(resolvedType, candidateType);
    }

    private void validateSynthOlType(VjoValidationCtx ctx, IJstNode jstNode, SynthOlType synthOlType, JstObjectLiteralType resolvedOType) {
        if (synthOlType == null || resolvedOType == null || !this.isOType((IJstType)resolvedOType)) {
            throw new IllegalArgumentException("obj literal couldn't be null, otype couldn't be null, otype must be OType");
        }
        boolean hasOptional = resolvedOType.hasOptionalFields();
        StringBuilder noneMatched = new StringBuilder().append('{');
        boolean matched = true;
        for (IJstProperty pty : resolvedOType.getAllPossibleProperties(false, true)) {
            IJstMethod matchMethod;
            IJstProperty ptyMatched;
            String ptyName;
            String string = ptyName = pty.getName() != null ? pty.getName().getName() : null;
            if (ptyName == null || (ptyMatched = synthOlType.getProperty(ptyName)) != null || hasOptional && resolvedOType.isOptionalField(pty) || (matchMethod = synthOlType.getMethod(ptyName)) != null && pty.getType() instanceof JstFuncType) continue;
            noneMatched.append(ptyName).append(',');
            matched = false;
        }
        if (!matched) {
            noneMatched.setCharAt(noneMatched.length() - 1, '}');
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{noneMatched.toString()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OBJLITERAL_ASSIGNABLE, ruleCtx);
        }
    }

    protected void validateVariantType(VjoValidationCtx ctx, IJstNode jstNode, String display, JstVariantType declaredType) {
        for (IJstType type : declaredType.getVariantTypes()) {
            this.validateComplexType(ctx, jstNode, display, type);
        }
    }

    protected void validateMixedType(VjoValidationCtx ctx, IJstNode jstNode, String display, JstMixedType declaredType) {
        for (IJstType type : declaredType.getMixedTypes()) {
            this.validateComplexType(ctx, jstNode, display, type);
        }
    }

    protected void validateAttributedType(VjoValidationCtx ctx, IJstNode jstNode, String display, JstAttributedType declaredType) {
        VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
        JstAttributedType attributedType = declaredType;
        String attributedName = attributedType.getAttributeName();
        IJstNode attributedBinding = attributedType.getJstBinding();
        this.validateComplexType(ctx, jstNode, display, attributedType.getAttributorType());
        if (attributedBinding == null) {
            boolean specialReasonFound = false;
            if (attributedType.getName() != null && attributedType.getName().startsWith("this.vj$.")) {
                this.satisfyRule(ctx, ruleRepo.ATTRIBUTOR_SHOULD_NOT_USE_VJ_RUNTIME, new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{attributedName, display}));
                specialReasonFound = true;
            } else if (attributedType.isStaticAttribute()) {
                if (attributedType.getMethod(attributedName, false, true) != null) {
                    this.satisfyRule(ctx, ruleRepo.NONE_STATIC_METHOD_SHOULD_NOT_BE_ACCESSED_FROM_STATIC_SCOPE, new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{attributedName, display}));
                    specialReasonFound = true;
                } else if (attributedType.getProperty(attributedName, false, true) != null) {
                    this.satisfyRule(ctx, ruleRepo.NONE_STATIC_PROPERTY_SHOULD_NOT_BE_ACCESSED_FROM_STATIC_SCOPE, new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{attributedName, display}));
                    specialReasonFound = true;
                }
            } else if (!attributedType.isStaticAttribute()) {
                if (attributedType.getMethod(attributedName, true, true) != null) {
                    this.satisfyRule(ctx, ruleRepo.STATIC_METHOD_SHOULD_NOT_BE_ACCESSED_FROM_NONE_STATIC_SCOPE, new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{attributedName, display}));
                    specialReasonFound = true;
                } else if (attributedType.getProperty(attributedName, true, true) != null) {
                    this.satisfyRule(ctx, ruleRepo.STATIC_PROPERTY_SHOULD_NOT_BE_ACCESSED_FROM_NONE_STATIC_SCOPE, new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{attributedName, display}));
                    specialReasonFound = true;
                }
            }
            if (!specialReasonFound) {
                IJstType knownType;
                IJstType ownerType;
                IJstType iJstType = ownerType = jstNode.getOwnerType() != null ? jstNode.getOwnerType() : ctx.getJstNode().getOwnerType();
                if (ownerType != null && (knownType = this.getKnownType(ctx, ownerType, attributedType.getAttributorType())) == null) {
                    specialReasonFound = true;
                }
            }
            if (!specialReasonFound) {
                this.satisfyRule(ctx, ruleRepo.PROPERTY_SHOULD_BE_DEFINED, new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{attributedName, display}));
            }
        } else if (attributedBinding instanceof IJstMethod) {
            boolean visible;
            IJstType callerType;
            IJstMethod attributedMethod = (IJstMethod)attributedBinding;
            IJstType ownerType = attributedMethod.getOwnerType();
            IJstType iJstType = callerType = jstNode.getOwnerType() != null ? jstNode.getOwnerType() : ctx.getJstNode().getOwnerType();
            if (attributedMethod != null && ownerType != null && callerType != null && !(visible = AccessControlUtil.isVisible(attributedMethod, ownerType, callerType))) {
                this.satisfyRule(ctx, ruleRepo.METHOD_SHOULD_BE_VISIBLE, new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{attributedName, display}));
            }
        } else if (attributedBinding instanceof IJstProperty) {
            boolean visible;
            IJstType callerType;
            IJstProperty attributedProperty = (IJstProperty)attributedBinding;
            IJstType ownerType = attributedProperty.getOwnerType();
            IJstType iJstType = callerType = jstNode.getOwnerType() != null ? jstNode.getOwnerType() : ctx.getJstNode().getOwnerType();
            if (attributedProperty != null && ownerType != null && callerType != null && !(visible = AccessControlUtil.isVisible(attributedProperty, ownerType, callerType))) {
                this.satisfyRule(ctx, ruleRepo.PROPERTY_SHOULD_BE_VISIBLE, new BaseVjoSemanticRuleCtx(jstNode, ctx.getGroupId(), new String[]{attributedName, display}));
            }
        }
    }

    protected boolean validateJstWithArgs(IJstType ownerType, IJstNode node, String display, VjoValidationCtx ctx, JstTypeWithArgs typeWithArgs) {
        List listParamTypes = typeWithArgs.getType().getParamTypes();
        List listArgTypes = typeWithArgs.getArgTypes();
        int argSize = listArgTypes.size();
        int paramSize = listParamTypes.size();
        VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
        if (argSize != paramSize) {
            String[] arguments = new String[]{String.valueOf(typeWithArgs.getType().getSimpleName()) + ((JstType)typeWithArgs.getType()).getParamsDecoration(), String.valueOf(typeWithArgs.getSimpleName()) + typeWithArgs.getArgsDecoration()};
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx(node, ctx.getGroupId(), arguments);
            this.satisfyRule(ctx, ruleRepo.GENERIC_PARAM_NUM_MISMATCH, ruleCtx);
            return false;
        }
        int i = 0;
        while (i < argSize) {
            IJstType upperBound;
            IJstType argType = (IJstType)listArgTypes.get(i);
            this.validateComplexType(ctx, node, display, argType);
            if (this.checkAndReportMissingImportProblem(ownerType, node, ctx, argType)) {
                return false;
            }
            List bounds = ((JstParamType)listParamTypes.get(i)).getBounds();
            if (bounds != null && !bounds.isEmpty() && !this.satisifies(upperBound = (IJstType)bounds.get(0), argType)) {
                String[] arguments = new String[]{String.valueOf(typeWithArgs.getType().getSimpleName()) + ((JstType)typeWithArgs.getType()).getParamsDecoration(), this.displayType((IJstType)typeWithArgs)};
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx(node, ctx.getGroupId(), arguments);
                this.satisfyRule(ctx, ruleRepo.GENERIC_PARAM_TYPE_MISMATCH, ruleCtx);
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String displayType(IJstType type) {
        StringBuilder sb = new StringBuilder();
        if (type == null) {
            return "NULL";
        }
        if (type instanceof JstArray) {
            return sb.append(this.displayType(((JstArray)type).getComponentType())).append("[]").toString();
        }
        if (type instanceof JstWildcardType) {
            sb.append("?");
            JstWildcardType p = (JstWildcardType)type;
            if (p.isUpperBound()) {
                sb.append(" extends ").append(this.displayType(p.getType()));
            } else if (p.isLowerBound()) {
                sb.append(" super ").append(this.displayType(p.getType()));
            }
            return sb.toString();
        }
        if (type instanceof JstTypeWithArgs) {
            JstTypeWithArgs withArgsType = (JstTypeWithArgs)type;
            sb.append(this.displayType(withArgsType.getType()));
            for (IJstType argType : withArgsType.getArgTypes()) {
                sb.append(this.displayType(argType)).append(',');
            }
            return sb.charAt(sb.length() - 1) == ',' ? sb.substring(0, sb.length() - 2) : sb.toString();
        }
        if (type instanceof JstAttributedType) {
            JstAttributedType attributedType = (JstAttributedType)type;
            IJstNode node = attributedType.getJstBinding();
            if (node instanceof IJstType) {
                return this.displayType((IJstType)node);
            }
            if (node instanceof IJstProperty) {
                return this.displayType(((IJstProperty)node).getType());
            }
            if (node instanceof IJstMethod) {
                return this.displayType(((IJstMethod)node).getRtnType());
            }
            return "UNKNOWN";
        }
        if (type instanceof JstFuncType) {
            JstFuncType jstFuncType = (JstFuncType)type;
            IJstMethod func = jstFuncType.getFunction();
            if (func != null && !func.isDispatcher()) {
                return JstDisplayUtils.getFullMethodString(func, null, false);
            }
            return "FUNCTION";
        }
        return type.getSimpleName();
    }

    public static void validateTypeResolution(VjoSemanticValidator validator, VjoValidationCtx ctx, IJstType syntaxOwnerType, IVjoDependencyVerifiable depVerifier, IExpr arg, String typeName) {
        if (!depVerifier.verify(syntaxOwnerType, typeName)) {
            if (typeName.length() > 0) {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)arg, ctx.getGroupId(), new String[]{typeName});
                validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().UNKNOWN_TYPE_NOT_IN_TYPE_SPACE, ruleCtx);
            }
            ctx.addUnresolvedType(typeName);
        }
    }
}

