/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo;

import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoGroupRulesCache;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRule;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.JstProblemId;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;

public class VjoSemanticProblemFactory {
    private static final VjoSemanticProblemFactory s_instance = new VjoSemanticProblemFactory();

    public static final VjoSemanticProblemFactory getInstance() {
        return s_instance;
    }

    private VjoSemanticProblemFactory() {
    }

    public VjoSemanticProblem createProblem(String[] arguments, String groupId, JstProblemId problemId, String errMsg, IJstNode sourceNode, VjoSemanticRule<?> reporter) {
        JstSource source = this.lookUpSource(sourceNode);
        int startOffset = source != null ? source.getStartOffSet() : -1;
        int endOffset = source != null ? source.getEndOffSet() : -1;
        int line = source != null ? source.getRow() : -1;
        int col = source != null ? source.getColumn() : -1;
        ProblemSeverity severity = VjoGroupRulesCache.getInstance().getRulePolicy(groupId, reporter).getProblemSeverity(problemId);
        VjoSemanticProblem prb = new VjoSemanticProblem(arguments, problemId, errMsg, null, startOffset, endOffset, line, col, severity);
        return prb;
    }

    private JstSource lookUpSource(IJstNode node) {
        if (node == null) {
            return null;
        }
        JstSource src = node.getSource();
        if (src != null) {
            return src;
        }
        return this.lookUpSource(node.getParentNode());
    }
}

