/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.kernel.stage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.af.common.error.ErrorFilter;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.af.common.error.ErrorObject;
import org.eclipse.vjet.af.common.error.IAggregateErrorContainer;
import org.eclipse.vjet.af.common.error.IDirectErrorsContainer;
import org.eclipse.vjet.kernel.stage.AbortStageProcessingException;
import org.eclipse.vjet.kernel.stage.DefaultStageManager;
import org.eclipse.vjet.kernel.stage.IStage;
import org.eclipse.vjet.kernel.stage.IStageListener;
import org.eclipse.vjet.kernel.stage.IStageManager;
import org.eclipse.vjet.kernel.stage.StageGraph;
import org.eclipse.vjet.kernel.stage.StagePostExecutionEvent;
import org.eclipse.vjet.kernel.stage.StagePreExecutionEvent;

public class StageDriver<T>
implements IDirectErrorsContainer,
IAggregateErrorContainer {
    private static final long serialVersionUID = 1L;
    private final IStageManager<T> m_mgr;
    private ErrorList m_directErrors;
    private final List<IStageListener> m_listeners = new ArrayList<IStageListener>();

    public StageDriver(StageGraph<T> graph) {
        if (graph == null) {
            throw new RuntimeException("graph cannot be null");
        }
        this.m_mgr = new DefaultStageManager<T>(graph);
    }

    public StageDriver(IStageManager<T> mgr) {
        if (mgr == null) {
            throw new RuntimeException("mgr cannot be null");
        }
        this.m_mgr = mgr;
    }

    public IStageManager<T> getManager() {
        return this.m_mgr;
    }

    public void execute() {
        try {
            IStage<T> stage = this.m_mgr.start();
            while (stage != null) {
                this.beforeDoWork(stage);
                stage.doWork();
                this.afterDoWork(stage);
                stage = this.m_mgr.next(stage);
            }
        }
        catch (AbortStageProcessingException abortStageProcessingException) {}
    }

    public void addError(ErrorObject error) {
        if (error == null) {
            return;
        }
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList();
        }
        this.m_directErrors.add(error);
    }

    public void addErrors(ErrorList errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList();
        }
        this.m_directErrors.add(errors);
    }

    @Override
    public boolean hasDirectErrors() {
        if (this.m_directErrors == null || this.m_directErrors.isEmpty()) {
            return false;
        }
        return this.m_directErrors.hasAnyErrors();
    }

    @Override
    public boolean hasDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors == null || this.m_directErrors.isEmpty()) {
            return false;
        }
        return this.m_directErrors.hasAnyErrors(errorFilter);
    }

    @Override
    public ErrorList getDirectErrors() {
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList(0);
        }
        return this.m_directErrors;
    }

    @Override
    public ErrorList getDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList(0);
        }
        return this.m_directErrors.getAllErrors(errorFilter);
    }

    @Override
    public void clearDirectErrors() {
        if (this.m_directErrors == null || this.m_directErrors.isEmpty()) {
            return;
        }
        this.m_directErrors.clearAllErrors();
    }

    @Override
    public void clearDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors == null || this.m_directErrors.isEmpty()) {
            return;
        }
        this.m_directErrors.clearAllErrors(errorFilter);
    }

    @Override
    public boolean hasAnyErrors() {
        return this.hasAnyErrors(new DefaultStageManager.AllErrorFilter());
    }

    @Override
    public boolean hasAnyErrors(ErrorFilter errorFilter) {
        if (this.hasDirectErrors(errorFilter)) {
            return true;
        }
        return this.m_mgr.hasAnyErrors(errorFilter);
    }

    @Override
    public ErrorList getAllErrors() {
        return this.getAllErrors(new DefaultStageManager.AllErrorFilter());
    }

    @Override
    public ErrorList getAllErrors(ErrorFilter errorFilter) {
        ErrorList answer = new ErrorList();
        answer.add(this.getDirectErrors(errorFilter));
        answer.add(this.m_mgr.getAllErrors(errorFilter));
        return answer;
    }

    public void addListener(IStageListener listener) {
        if (listener == null) {
            return;
        }
        if (this.m_listeners.contains(listener)) {
            return;
        }
        this.m_listeners.add(listener);
    }

    public boolean removeListener(IStageListener listener) {
        return this.m_listeners.remove(listener);
    }

    protected void beforeDoWork(IStage stage) {
        for (IStageListener listener : this.m_listeners) {
            try {
                if (!listener.isApplicable(stage)) continue;
                StagePreExecutionEvent event = new StagePreExecutionEvent(stage);
                event.processListener(listener);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception in listener:" + listener.getClass().getName(), e);
            }
        }
    }

    protected void afterDoWork(IStage stage) {
        int i = this.m_listeners.size() - 1;
        while (i >= 0) {
            IStageListener listener = this.m_listeners.get(i);
            try {
                if (listener.isApplicable(stage)) {
                    StagePostExecutionEvent event = new StagePostExecutionEvent(stage);
                    event.processListener(listener);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception in listener:" + listener.getClass().getName(), e);
            }
            --i;
        }
    }
}

