/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.preferences.IFieldValidator;
import org.eclipse.dltk.mod.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.mod.ui.preferences.ITextConverter;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ControlBindingManager {
    private Map textControls;
    private final Map textTransformers = new HashMap();
    private Map comboControls;
    private Map buttonControls = new HashMap();
    private IPreferenceDelegate preferenceDelegate;
    private IStatusChangeListener changeListener;
    private DependencyManager dependencyManager;
    private ValidatorManager validatorManager;

    public ControlBindingManager(IPreferenceDelegate delegate, IStatusChangeListener listener) {
        this.comboControls = new HashMap();
        this.textControls = new HashMap();
        this.validatorManager = new ValidatorManager();
        this.dependencyManager = new DependencyManager();
        this.changeListener = listener;
        this.preferenceDelegate = delegate;
    }

    public void initialize() {
        String value;
        Object key;
        for (Text text : this.textControls.keySet()) {
            key = this.textControls.get(text);
            value = this.preferenceDelegate.getString(key);
            ITextConverter textTransformer = (ITextConverter)this.textTransformers.get(text);
            if (textTransformer != null) {
                value = textTransformer.convertPreference(value);
            }
            text.setText(value);
        }
        for (Button button : this.buttonControls.keySet()) {
            key = this.buttonControls.get(button);
            button.setSelection(this.preferenceDelegate.getBoolean(key));
        }
        for (Combo combo : this.comboControls.keySet()) {
            key = this.comboControls.get(combo);
            value = this.preferenceDelegate.getString(key);
            String[] items = combo.getItems();
            boolean selected = false;
            int i = 0;
            while (i < items.length) {
                if (items[i].toLowerCase().equals(value.toLowerCase())) {
                    combo.select(i);
                    selected = true;
                    break;
                }
                ++i;
            }
            if (selected) continue;
            combo.select(0);
        }
        this.dependencyManager.initialize();
    }

    public void bindControl(final Button button, final Object key, Control[] slaves) {
        if (key != null) {
            this.buttonControls.put(button, key);
        }
        if (slaves != null) {
            this.dependencyManager.createDependency(button, slaves);
        }
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean state = button.getSelection();
                ControlBindingManager.this.preferenceDelegate.setBoolean(key, state);
                ControlBindingManager.this.updateStatus(StatusInfo.OK_STATUS);
            }
        });
    }

    public void bindControl(Text text, Object key, IFieldValidator validator) {
        this.bindControl(text, key, validator, null);
    }

    public void bindControl(final Text text, final Object key, IFieldValidator validator, final ITextConverter transformer) {
        if (key != null) {
            if (this.textControls.containsKey(key)) {
                IllegalArgumentException error = new IllegalArgumentException("Duplicate control " + key);
                DLTKUIPlugin.log(error);
                if (DLTKCore.DEBUG) {
                    throw error;
                }
            }
            this.textControls.put(text, key);
            if (transformer != null) {
                this.textTransformers.put(text, transformer);
            }
        }
        if (validator != null) {
            this.validatorManager.registerValidator(text, validator);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = ControlBindingManager.this.validateText(text);
                if (key != null && status.getSeverity() != 4) {
                    String value = text.getText();
                    if (transformer != null) {
                        value = transformer.convertInput(value);
                    }
                    ControlBindingManager.this.preferenceDelegate.setString(key, value);
                }
                ControlBindingManager.this.updateStatus(status);
            }
        });
    }

    public void bindControl(final Combo combo, final Object key) {
        if (key != null) {
            this.comboControls.put(combo, key);
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                ControlBindingManager.this.preferenceDelegate.setString(key, combo.getItem(index));
                ControlBindingManager.this.changeListener.statusChanged(StatusInfo.OK_STATUS);
            }
        });
    }

    private IStatus validateText(Text text) {
        IFieldValidator validator = this.validatorManager.getValidator((Control)text);
        if (validator != null && text.isEnabled()) {
            return validator.validate(text.getText());
        }
        return StatusInfo.OK_STATUS;
    }

    public IStatus getStatus() {
        IStatus status = StatusInfo.OK_STATUS;
        Iterator iter = this.textControls.keySet().iterator();
        while (iter.hasNext()) {
            IStatus s = this.validateText((Text)iter.next());
            status = StatusUtil.getMoreSevere(s, status);
        }
        return status;
    }

    protected void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            Iterator iter = this.textControls.keySet().iterator();
            while (iter.hasNext()) {
                IStatus s = this.validateText((Text)iter.next());
                status = StatusUtil.getMoreSevere(s, status);
            }
        }
        this.changeListener.statusChanged(status);
    }

    class DependencyManager {
        private List masterSlaveListeners = new ArrayList();

        DependencyManager() {
        }

        public void initialize() {
            Iterator it = this.masterSlaveListeners.iterator();
            while (it.hasNext()) {
                ((SelectionListener)it.next()).widgetSelected(null);
            }
        }

        public void createDependency(final Button master, final Control[] slaves) {
            SelectionListener listener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean state = master.getSelection();
                    int i = 0;
                    while (i < slaves.length) {
                        slaves[i].setEnabled(state);
                        ++i;
                    }
                    ControlBindingManager.this.changeListener.statusChanged(StatusInfo.OK_STATUS);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            master.addSelectionListener(listener);
            this.masterSlaveListeners.add(listener);
        }
    }

    class ValidatorManager {
        private Map map = new HashMap();

        ValidatorManager() {
        }

        public IFieldValidator getValidator(Control control) {
            return (IFieldValidator)this.map.get(control);
        }

        public void registerValidator(Text text, IFieldValidator validator) {
            this.map.put(text, validator);
        }

        public void unregisterValidator(Text text) {
            this.map.remove(text);
        }
    }
}

