/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.core.commands.IHandler;
import org.eclipse.dltk.mod.internal.ui.actions.DLTKQuickMenuAction;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.ui.actions.FormatAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.dltk.mod.ui.source.menu";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    public static final String GROUP_EXTERNALIZE = "externalizeGroup";
    public static final String GROUP_COMMENT = "commentGroup";
    public static final String GROUP_EDIT = "editGroup";
    private ScriptEditor fEditor;
    private IWorkbenchSite fSite;
    private final String fGroupName;
    private static final String QUICK_MENU_ID = "org.eclipse.dltk.mod.ui.edit.text.java.source.quickMenu";
    private DLTKQuickMenuAction fQuickAccessAction;
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;
    private FormatAction formatAction;

    public GenerateActionGroup(ScriptEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        this.installQuickAccessAction();
    }

    public GenerateActionGroup(IViewPart part, String groupName) {
        this.fSite = part.getSite();
        this.fGroupName = groupName;
        this.formatAction = new FormatAction(this.fSite);
        this.installQuickAccessAction();
    }

    public GenerateActionGroup(Page page, String groupName) {
        this.fSite = page.getSite();
        this.fGroupName = groupName;
        this.formatAction = new FormatAction(this.fSite);
        this.installQuickAccessAction();
    }

    private void installQuickAccessAction() {
        this.fHandlerService = (IHandlerService)this.fSite.getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            this.fQuickAccessAction = new SourceQuickAccessAction(this.fEditor);
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(this.fQuickAccessAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.fQuickAccessAction));
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        if (this.fEditor != null) {
            this.setGlobalActionHandlers(actionBar);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        String menuText = "Source";
        if (this.fQuickAccessAction != null) {
            menuText = this.fQuickAccessAction.addShortcut(menuText);
        }
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.isEditorOwner()) {
            this.fillEditorSubMenu(menu);
        } else {
            this.fillViewSubMenu(menu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        added += this.addEditorAction(source, "org.eclipse.dltk.mod.ui.actions.AddBlockComment");
        added += this.addEditorAction(source, "org.eclipse.dltk.mod.ui.actions.RemoveBlockComment");
        added += this.addEditorAction(source, "org.eclipse.dltk.mod.ui.actions.ToggleComment");
        added += this.addEditorAction(source, "org.eclipse.dltk.mod.ui.actions.Comment");
        added += this.addEditorAction(source, "org.eclipse.dltk.mod.ui.actions.Uncomment");
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        added += this.addEditorAction(source, "org.eclipse.dltk.mod.ui.actions.Format");
        added += this.addEditorAction(source, "org.eclipse.dltk.mod.ui.actions.FormatElement");
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addEditorAction(source, "org.eclipse.dltk.mod.ui.actions.Indent");
    }

    private int fillViewSubMenu(IMenuManager source) {
        return 0;
    }

    public void dispose() {
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        this.fEditor = null;
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars bars) {
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.Comment", this.getAction((ITextEditor)this.fEditor, "org.eclipse.dltk.mod.ui.actions.Comment"));
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.Uncomment", this.getAction((ITextEditor)this.fEditor, "org.eclipse.dltk.mod.ui.actions.Uncomment"));
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.ToggleComment", this.getAction((ITextEditor)this.fEditor, "org.eclipse.dltk.mod.ui.actions.ToggleComment"));
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.AddBlockComment", this.getAction((ITextEditor)this.fEditor, "org.eclipse.dltk.mod.ui.actions.AddBlockComment"));
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.RemoveBlockComment", this.getAction((ITextEditor)this.fEditor, "org.eclipse.dltk.mod.ui.actions.RemoveBlockComment"));
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.Format", this.getAction((ITextEditor)this.fEditor, "org.eclipse.dltk.mod.ui.actions.Format"));
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.FormatElement", this.getAction((ITextEditor)this.fEditor, "org.eclipse.dltk.mod.ui.actions.FormatElement"));
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.Indent", this.getAction((ITextEditor)this.fEditor, "org.eclipse.dltk.mod.ui.actions.Indent"));
        bars.updateActionBars();
    }

    protected final IAction getAction(ITextEditor editor, String actionId) {
        return editor == null || actionId == null ? null : editor.getAction(actionId);
    }

    protected int addAction(IMenuManager menu, String groupName, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.appendToGroup(groupName, action);
            return 1;
        }
        return 0;
    }

    protected int addEditorAction(IMenuManager menu, String groupName, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.appendToGroup(groupName, action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }

    private class SourceQuickAccessAction
    extends DLTKQuickMenuAction {
        public SourceQuickAccessAction(ScriptEditor editor) {
            super(editor, GenerateActionGroup.QUICK_MENU_ID);
        }

        @Override
        protected void fillMenu(IMenuManager menu) {
            GenerateActionGroup.this.fillQuickMenu(menu);
        }
    }
}

