/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.internal.core.JSSourceType;
import org.eclipse.dltk.mod.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.actions.FindReferencesInWorkingSetAction;
import org.eclipse.dltk.mod.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.mod.ui.search.QuerySpecification;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public abstract class FindSatisfiersInWorkingSetAction
extends FindReferencesInWorkingSetAction {
    private boolean isInterfaceForSearchSatisfier = false;
    private IWorkingSet[] fWorkingSets;

    public FindSatisfiersInWorkingSetAction(IWorkbenchSite site) {
        this(site, (IWorkingSet[])null);
    }

    public FindSatisfiersInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(site);
        this.fWorkingSets = workingSets;
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IModelElement element;
            IModelElement[] elements = SelectionConverter.codeResolveForked((IEditorPart)this.getEditor(), true);
            if (elements.length > 0 && this.canOperateOn(elements[0]) && (element = elements[0]) != null) {
                try {
                    this.isInterfaceForSearchSatisfier = ((JSSourceType)element).isInterface();
                }
                catch (ModelException modelException) {}
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        if (!this.isInterfaceForSearchSatisfier) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)SearchMessages.DLTKElementAction_operationUnavailable_title, (String)SearchMessages.DLTKElementAction_operationUnavailable_interface);
            return;
        }
        super.run(selection);
    }

    public FindSatisfiersInWorkingSetAction(ScriptEditor editor) {
        this(editor, null);
    }

    public FindSatisfiersInWorkingSetAction(ScriptEditor editor, IWorkingSet[] workingSets) {
        super(editor);
        this.fWorkingSets = workingSets;
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindReferencesInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesInWorkingSetAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_REF);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add help supprot here...");
        }
    }

    @Override
    int getLimitTo() {
        return 8;
    }

    @Override
    QuerySpecification createQuery(IModelElement element) throws ModelException {
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        IWorkingSet[] workingSets = this.fWorkingSets;
        if (this.fWorkingSets == null && (workingSets = factory.queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        IDLTKSearchScope scope = factory.createSearchScope(workingSets, true, this.getLanguageToolkit());
        String description = factory.getWorkingSetScopeDescription(workingSets, true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

