/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.workingsets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.dltk.mod.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class SelectWorkingSetAction
extends Action {
    private IWorkbenchPartSite fSite;
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public SelectWorkingSetAction(WorkingSetFilterActionGroup actionGroup, IWorkbenchPartSite site) {
        this(actionGroup);
        this.fSite = site;
    }

    public SelectWorkingSetAction(WorkingSetFilterActionGroup actionGroup, Shell shell) {
        this(actionGroup);
        this.fShell = shell;
    }

    private SelectWorkingSetAction(WorkingSetFilterActionGroup actionGroup) {
        super(WorkingSetMessages.SelectWorkingSetAction_text);
        Assert.isNotNull((Object)actionGroup);
        this.setToolTipText(WorkingSetMessages.SelectWorkingSetAction_toolTip);
        this.fActionGroup = actionGroup;
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public void run() {
        Shell shell = this.getShell();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(shell, false);
        IWorkingSet workingSet = this.fActionGroup.getWorkingSet();
        if (workingSet != null) {
            dialog.setSelection(new IWorkingSet[]{workingSet});
        }
        if (dialog.open() == 0) {
            IWorkingSet[] result = dialog.getSelection();
            if (result != null && result.length > 0) {
                this.fActionGroup.setWorkingSet(result[0], true);
                manager.addRecentWorkingSet(result[0]);
            } else {
                this.fActionGroup.setWorkingSet(null, true);
            }
        }
    }

    private Shell getShell() {
        if (this.fSite != null) {
            return this.fSite.getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }
}

