/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.text;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ElementChangedEvent;
import org.eclipse.dltk.mod.core.IElementChangedListener;
import org.eclipse.dltk.mod.core.IModelElementDelta;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.text.ScriptCompositeReconcilingStrategy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptReconciler
extends MonoReconciler {
    private ITextEditor fTextEditor;
    private IPartListener fPartListener;
    private ShellListener fActivationListener;
    private Object fMutex;
    private IElementChangedListener fScriptElementChangedListener;
    private volatile boolean fHasModelChanged = true;
    private volatile boolean fIsEditorActive = true;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private boolean fIninitalProcessDone = false;
    private ISourceModule fReconciledElement;
    private volatile Thread reconcilerThread = null;

    public ScriptReconciler(ITextEditor editor, IReconcilingStrategy strategy, boolean isIncremental) {
        super(strategy, isIncremental);
        this.fTextEditor = editor;
        this.fMutex = editor instanceof ScriptEditor ? ((ScriptEditor)editor).getReconcilerLock() : new Object();
    }

    private boolean isSaveDelta(IModelElementDelta[] delta) {
        if (delta.length != 1) {
            return false;
        }
        if (delta[0].getFlags() == 262144 && delta[0].getElement().equals(this.fReconciledElement)) {
            return true;
        }
        return this.isSaveDelta(delta[0].getAffectedChildren());
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fPartListener = new PartListener();
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener(this.fPartListener);
        this.fActivationListener = new ActivationListener((Control)textViewer.getTextWidget());
        Shell shell = window.getShell();
        shell.addShellListener(this.fActivationListener);
        this.fScriptElementChangedListener = new ElementChangedListener();
        DLTKCore.addElementChangedListener((IElementChangedListener)this.fScriptElementChangedListener);
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener);
        IPreferenceStore store = this.getCombinedPreferenceStore();
        if (store != null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("spellingEnabled".equals(event.getProperty()) || "spellingEngine".equals(event.getProperty())) {
                        ScriptReconciler.this.forceReconciling();
                    }
                }
            };
            store.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fReconciledElement = EditorUtility.getEditorInputModelElement((IEditorPart)this.fTextEditor, false);
    }

    protected IPreferenceStore getCombinedPreferenceStore() {
        return null;
    }

    public void uninstall() {
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener(this.fPartListener);
        this.fPartListener = null;
        Shell shell = window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.removeShellListener(this.fActivationListener);
        }
        this.fActivationListener = null;
        DLTKCore.removeElementChangedListener((IElementChangedListener)this.fScriptElementChangedListener);
        this.fScriptElementChangedListener = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
        this.fResourceChangeListener = null;
        if (this.fPropertyChangeListener != null) {
            IPreferenceStore store = this.getCombinedPreferenceStore();
            if (store != null) {
                store.removePropertyChangeListener(this.fPropertyChangeListener);
            }
            this.fPropertyChangeListener = null;
        }
        super.uninstall();
    }

    protected void forceReconciling() {
        if (!this.fIninitalProcessDone) {
            return;
        }
        super.forceReconciling();
        ScriptCompositeReconcilingStrategy strategy = (ScriptCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(false);
    }

    protected void aboutToBeReconciled() {
        ScriptCompositeReconcilingStrategy strategy = (ScriptCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.aboutToBeReconciled();
    }

    protected void reconcilerReset() {
        super.reconcilerReset();
        ScriptCompositeReconcilingStrategy strategy = (ScriptCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialProcess() {
        this.reconcilerThread = Thread.currentThread();
        Object object = this.fMutex;
        synchronized (object) {
            super.initialProcess();
        }
        this.fIninitalProcessDone = true;
    }

    private synchronized boolean hasModelChanged() {
        return this.fHasModelChanged;
    }

    private synchronized void setModelChanged(boolean state) {
        this.fHasModelChanged = state;
    }

    private synchronized boolean isEditorActive() {
        return this.fIsEditorActive;
    }

    private synchronized void setEditorActive(boolean state) {
        this.fIsEditorActive = state;
    }

    protected boolean isRunningInReconcilerThread() {
        return Thread.currentThread() == this.reconcilerThread;
    }

    private class ActivationListener
    extends ShellAdapter {
        private Control fControl;

        public ActivationListener(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
        }

        public void shellActivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.isVisible()) {
                if (ScriptReconciler.this.hasModelChanged()) {
                    ScriptReconciler.this.forceReconciling();
                }
                ScriptReconciler.this.setEditorActive(true);
            }
        }

        public void shellDeactivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.getShell() == e.getSource()) {
                ScriptReconciler.this.setModelChanged(false);
                ScriptReconciler.this.setEditorActive(false);
            }
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (ScriptReconciler.this.isRunningInReconcilerThread()) {
                return;
            }
            ScriptReconciler.this.setModelChanged(true);
            if (ScriptReconciler.this.isEditorActive() && !ScriptReconciler.this.isSaveDelta(event.getDelta().getAffectedChildren())) {
                ScriptReconciler.this.forceReconciling();
            }
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == ScriptReconciler.this.fTextEditor) {
                if (ScriptReconciler.this.hasModelChanged()) {
                    ScriptReconciler.this.forceReconciling();
                }
                ScriptReconciler.this.setEditorActive(true);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == ScriptReconciler.this.fTextEditor) {
                ScriptReconciler.this.setModelChanged(false);
                ScriptReconciler.this.setEditorActive(false);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        private IResource getResource() {
            IEditorInput input = ScriptReconciler.this.fTextEditor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                return fileInput.getFile();
            }
            return null;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta child;
            if (ScriptReconciler.this.isRunningInReconcilerThread()) {
                return;
            }
            IResourceDelta delta = e.getDelta();
            IResource resource = this.getResource();
            if (delta != null && resource != null && (child = delta.findMember(resource.getFullPath())) != null) {
                IMarkerDelta[] deltas = child.getMarkerDeltas();
                int i = deltas.length;
                while (--i >= 0) {
                    if (!deltas[i].isSubtypeOf("org.eclipse.core.resources.problemmarker")) continue;
                    ScriptReconciler.this.forceReconciling();
                    return;
                }
            }
        }
    }
}

