/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.navigator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.mod.internal.ui.navigator.ScriptExplorerProblemsDecorator;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;

public class ScriptExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    protected ScriptExplorerContentProvider fContentProvider;
    private Map fWorkingSetImages;
    private boolean fIsFlatLayout;
    private ScriptExplorerProblemsDecorator fProblemDecorator = new ScriptExplorerProblemsDecorator();

    public ScriptExplorerLabelProvider(ScriptExplorerContentProvider cp, IPreferenceStore store) {
        super(0x201200000002BL | ScriptElementLabels.ALL_CATEGORY, 3, store);
        this.addLabelDecorator(this.fProblemDecorator);
        Assert.isNotNull((Object)cp);
        this.fContentProvider = cp;
        this.fWorkingSetImages = null;
    }

    private String getSpecificText(Object element) {
        if (!this.fIsFlatLayout && element instanceof IScriptFolder) {
            IScriptFolder fragment = (IScriptFolder)element;
            Object parent = this.fContentProvider.getHierarchicalPackageParent(fragment);
            if (parent instanceof IScriptFolder) {
                return this.getNameDelta((IScriptFolder)parent, fragment);
            }
            if (parent instanceof IFolder) {
                return this.getNameDelta((IFolder)parent, fragment);
            }
        } else if (element instanceof IWorkingSet) {
            return ((IWorkingSet)element).getLabel();
        }
        return null;
    }

    @Override
    public String getText(Object element) {
        String text = this.getSpecificText(element);
        if (text != null) {
            return this.decorateText(text, element);
        }
        return super.getText(element);
    }

    private String getNameDelta(IScriptFolder parent, IScriptFolder fragment) {
        String prefix = String.valueOf(parent.getElementName()) + '.';
        String fullName = fragment.getElementName();
        if (fullName.startsWith(prefix)) {
            return fullName.substring(prefix.length());
        }
        return fullName;
    }

    private String getNameDelta(IFolder parent, IScriptFolder fragment) {
        IPath fullPath;
        IPath prefix = parent.getFullPath();
        if (prefix.isPrefixOf(fullPath = fragment.getPath())) {
            StringBuffer buf = new StringBuffer();
            int i = prefix.segmentCount();
            while (i < fullPath.segmentCount()) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(fullPath.segment(i));
                ++i;
            }
            return buf.toString();
        }
        return fragment.getElementName();
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof IWorkingSet) {
            Image result;
            ImageDescriptor image = ((IWorkingSet)element).getImageDescriptor();
            if (this.fWorkingSetImages == null) {
                this.fWorkingSetImages = new HashMap();
            }
            if ((result = (Image)this.fWorkingSetImages.get(image)) == null) {
                result = image.createImage();
                this.fWorkingSetImages.put(image, result);
            }
            return this.decorateImage(result, element);
        }
        return super.getImage(element);
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
        this.fProblemDecorator.setIsFlatLayout(state);
    }

    @Override
    public void dispose() {
        if (this.fWorkingSetImages != null) {
            Iterator iter = this.fWorkingSetImages.values().iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
        }
        super.dispose();
    }
}

