/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.callhierarchy;

import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.dltk.mod.ui.ModelElementLabelProvider;
import org.eclipse.dltk.mod.ui.ScriptElementImageProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

class HistoryAction
extends Action {
    private static ModelElementLabelProvider fLabelProvider = new ModelElementLabelProvider(2051);
    private CallHierarchyViewPart fView;
    private IMethod fMethod;

    public HistoryAction(CallHierarchyViewPart viewPart, IMethod element) {
        super("", 8);
        this.fView = viewPart;
        this.fMethod = element;
        String elementName = this.getElementLabel((IModelElement)element);
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor((IModelElement)element));
        this.setDescription(Messages.format(CallHierarchyMessages.HistoryAction_description, elementName));
        this.setToolTipText(Messages.format(CallHierarchyMessages.HistoryAction_tooltip, elementName));
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    private ImageDescriptor getImageDescriptor(IModelElement elem) {
        ScriptElementImageProvider imageProvider = new ScriptElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor(elem, 0);
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fView.gotoHistoryEntry(this.fMethod);
    }

    private String getElementLabel(IModelElement element) {
        return fLabelProvider.getText(element);
    }
}

