/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IOpenable;
import org.eclipse.dltk.mod.core.ISourceModule;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static IFile[] getFiles(ISourceModule[] cus) {
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        int i = 0;
        while (i < cus.length) {
            IResource resource = ResourceUtil.getResource(cus[i]);
            if (resource != null && resource.getType() == 1) {
                files.add(resource);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static IFile getFile(ISourceModule cu) {
        IResource resource = ResourceUtil.getResource(cu);
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    public static IResource getResource(ISourceModule cu) {
        return cu.getResource();
    }

    public static IResource getResource(IMember member) {
        return ResourceUtil.getResource(member.getSourceModule());
    }

    public static IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IModelElement) {
            return ResourceUtil.getResource((IModelElement)o);
        }
        return null;
    }

    private static IResource getResource(IModelElement element) {
        if (element.getElementType() == 5) {
            return ResourceUtil.getResource((ISourceModule)element);
        }
        if (element instanceof IOpenable) {
            return element.getResource();
        }
        return null;
    }
}

