/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching.sourcelookup.containers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.launching.LaunchingMessages;
import org.eclipse.dltk.mod.launching.sourcelookup.containers.ScriptProjectSourceContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScriptProjectSourceContainerTypeDelegate
extends AbstractSourceContainerTypeDelegate {
    private static String SCRIPT_PROJECT = "scriptProject";

    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if (SCRIPT_PROJECT.equals(element.getNodeName())) {
                String string = element.getAttribute("name");
                if (string == null || string.length() == 0) {
                    this.abort(LaunchingMessages.ScriptProjectSourceContainerTypeDelegate_5, null);
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(string);
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                return new ScriptProjectSourceContainer(scriptProject);
            }
            this.abort(LaunchingMessages.ScriptProjectSourceContainerTypeDelegate_6, null);
        }
        this.abort(LaunchingMessages.ScriptProjectSourceContainerTypeDelegate_7, null);
        return null;
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        ScriptProjectSourceContainer project = (ScriptProjectSourceContainer)container;
        Document document = this.newDocument();
        Element element = document.createElement(SCRIPT_PROJECT);
        element.setAttribute("name", project.getName());
        document.appendChild(element);
        return this.serializeDocument(document);
    }
}

