/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.hierarchy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IFileHierarchyInfo;
import org.eclipse.dltk.mod.core.IFileHierarchyResolver;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.search.SearchEngine;
import org.eclipse.dltk.mod.core.search.SearchMatch;
import org.eclipse.dltk.mod.core.search.SearchParticipant;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.core.search.SearchRequestor;
import org.eclipse.dltk.mod.internal.core.Openable;
import org.eclipse.dltk.mod.internal.core.hierarchy.HierarchyBuilder;

public class HierarchyResolver {
    private static final String TWO_COLONS = "::";
    private HierarchyBuilder hierarchyBuilder;
    private SearchEngine engine;

    public HierarchyResolver(HierarchyBuilder hierarchy) {
        this.hierarchyBuilder = hierarchy;
        this.engine = new SearchEngine();
    }

    public void resolve(boolean computeSubtypes) throws CoreException {
        IType focusType = this.hierarchyBuilder.getType();
        this.hierarchyBuilder.hierarchy.initialize(0);
        if (computeSubtypes) {
            this.computeSubtypes(focusType);
        }
        this.computeSupertypes(focusType);
    }

    protected void computeSubtypes(IType focusType) throws CoreException {
        final HashMap superTypeToExtender = new HashMap();
        SearchRequestor typesCollector = new SearchRequestor(){

            @Override
            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IType element = (IType)match.getElement();
                String[] superClasses = element.getSuperClasses();
                if (superClasses != null) {
                    int i = 0;
                    while (i < superClasses.length) {
                        String s = superClasses[i];
                        LinkedList<String> extenders = (LinkedList<String>)superTypeToExtender.get(s);
                        if (extenders == null) {
                            extenders = new LinkedList<String>();
                            superTypeToExtender.put(s, extenders);
                        }
                        extenders.add(element.getTypeQualifiedName(HierarchyResolver.TWO_COLONS));
                        ++i;
                    }
                }
            }
        };
        SearchPattern pattern = SearchPattern.createPattern("*", 0, 0, 2, this.hierarchyBuilder.hierarchy.scope.getLanguageToolkit());
        this.engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.hierarchyBuilder.hierarchy.scope, typesCollector, this.hierarchyBuilder.hierarchy.progressMonitor);
        IFileHierarchyResolver fileHierarchyResolver = HierarchyResolver.createFileHierarchyResolver(focusType);
        IFileHierarchyInfo hierarchyInfo = null;
        if (fileHierarchyResolver != null) {
            hierarchyInfo = fileHierarchyResolver.resolveDown(focusType.getSourceModule(), this.hierarchyBuilder.hierarchy.progressMonitor);
        }
        this.computeSubtypesFor(focusType, superTypeToExtender, new HashMap(), hierarchyInfo, new HashSet());
    }

    protected void computeSubtypesFor(IType focusType, Map superTypeToExtender, Map subTypesCache, IFileHierarchyInfo hierarchyInfo, Set processedTypes) throws CoreException {
        List extenders = (List)superTypeToExtender.get(focusType.getTypeQualifiedName(TWO_COLONS));
        if (extenders != null) {
            IType subType;
            IType[] subTypes = this.searchTypes(extenders.toArray(new String[extenders.size()]), subTypesCache, hierarchyInfo);
            int i = 0;
            while (i < subTypes.length) {
                subType = subTypes[i];
                this.hierarchyBuilder.hierarchy.addSubtype(focusType, subType);
                ++i;
            }
            i = 0;
            while (i < subTypes.length) {
                subType = subTypes[i];
                if (processedTypes.add(subType)) {
                    this.computeSubtypesFor(subType, superTypeToExtender, subTypesCache, hierarchyInfo, processedTypes);
                }
                ++i;
            }
        }
    }

    protected void computeSupertypes(IType focusType) throws CoreException {
        IFileHierarchyResolver fileHierarchyResolver = HierarchyResolver.createFileHierarchyResolver(focusType);
        IFileHierarchyInfo hierarchyInfo = null;
        if (fileHierarchyResolver != null) {
            hierarchyInfo = fileHierarchyResolver.resolveUp(focusType.getSourceModule(), this.hierarchyBuilder.hierarchy.progressMonitor);
        }
        this.computeSupertypesFor(focusType, hierarchyInfo, new HashSet());
    }

    protected void computeSupertypesFor(IType focusType, IFileHierarchyInfo hierarchyInfo, Set processedTypes) throws CoreException {
        processedTypes.add(focusType);
        String[] superClasses = focusType.getSuperClasses();
        if (superClasses != null && superClasses.length > 0) {
            IType superclass;
            IType[] searchTypes = this.searchTypes(superClasses, hierarchyInfo);
            int i = 0;
            while (i < searchTypes.length) {
                superclass = searchTypes[i];
                this.hierarchyBuilder.hierarchy.cacheSuperclass(focusType, superclass);
                ++i;
            }
            i = 0;
            while (i < searchTypes.length) {
                superclass = searchTypes[i];
                if (!processedTypes.contains(superclass)) {
                    this.computeSupertypesFor(superclass, hierarchyInfo, processedTypes);
                }
                ++i;
            }
        } else if (!this.hierarchyBuilder.hierarchy.contains(focusType)) {
            this.hierarchyBuilder.hierarchy.addRootClass(focusType);
        }
    }

    protected IType[] searchTypes(String[] types, IFileHierarchyInfo hierarchyInfo) throws CoreException {
        return this.searchTypes(types, null, hierarchyInfo);
    }

    protected IType[] searchTypes(String[] types, Map cache, IFileHierarchyInfo hierarchyInfo) throws CoreException {
        LinkedList<IType> result = new LinkedList<IType>();
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            result.addAll(Arrays.asList(this.searchTypes(type, cache, hierarchyInfo)));
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    protected IType[] searchTypes(String type, IFileHierarchyInfo hierarchyInfo) throws CoreException {
        return this.searchTypes(type, null, hierarchyInfo);
    }

    protected IType[] searchTypes(String type, Map cache, final IFileHierarchyInfo hierarchyInfo) throws CoreException {
        if (cache != null && cache.containsKey(type)) {
            return (IType[])cache.get(type);
        }
        final LinkedList result = new LinkedList();
        final LinkedList filteredTypes = new LinkedList();
        SearchRequestor typesCollector = new SearchRequestor(){

            @Override
            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IType type = (IType)match.getElement();
                if (hierarchyInfo != null && !hierarchyInfo.exists(type.getSourceModule())) {
                    filteredTypes.add(type);
                    return;
                }
                result.add(type);
            }
        };
        SearchPattern pattern = SearchPattern.createPattern(type, 0, 0, 8, this.hierarchyBuilder.hierarchy.scope.getLanguageToolkit());
        this.engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.hierarchyBuilder.hierarchy.scope, typesCollector, this.hierarchyBuilder.hierarchy.progressMonitor);
        if (result.isEmpty()) {
            result.addAll(filteredTypes);
        }
        IType[] types = result.toArray(new IType[result.size()]);
        if (cache != null) {
            cache.put(type, types);
        }
        return types;
    }

    public void resolve(Openable[] openables, HashSet localTypes) {
        block2: {
            try {
                this.resolve(true);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    private static IFileHierarchyResolver createFileHierarchyResolver(IType type) throws CoreException {
        IFileHierarchyResolver fileHierarchyResolver = null;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        if (toolkit != null) {
            fileHierarchyResolver = DLTKLanguageManager.getFileHierarchyResolver(toolkit.getNatureId());
        }
        return fileHierarchyResolver;
    }
}

