/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.JSSourceMethodElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.SourceField;
import org.eclipse.dltk.mod.internal.core.SourceMethod;
import org.eclipse.dltk.mod.internal.core.SourceMethodElementInfo;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.VjoLocalVariable;
import org.eclipse.dltk.mod.internal.core.util.Util;
import org.eclipse.vjet.eclipse.core.IJSMethod;
import org.eclipse.vjet.eclipse.core.IJSType;

public class JSSourceMethod
extends SourceMethod
implements IJSMethod {
    protected String[] m_parameterTypes;

    public JSSourceMethod(ModelElement parent, String name) {
        this(parent, name, null);
    }

    public JSSourceMethod(ModelElement parent, String name, String[] parameterTypes) {
        super(parent, name);
        Assert.isTrue((name.indexOf(46) == -1 ? 1 : 0) != 0);
        this.m_parameterTypes = parameterTypes == null ? CharOperation.NO_STRINGS : parameterTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof JSSourceMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.m_parameterTypes, ((JSSourceMethod)o).m_parameterTypes);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        int length = this.m_parameterTypes.length;
        while (i < length) {
            hash = Util.combineHashCodes(hash, this.m_parameterTypes[i].hashCode());
            ++i;
        }
        return hash;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            SourceMethodElementInfo methodInfo = (SourceMethodElementInfo)info;
            int flags = methodInfo.getModifiers();
            if (Flags.isStatic(flags)) {
                buffer.append("static ");
            }
            if (!methodInfo.isConstructor()) {
                buffer.append(methodInfo.getReturnTypeName());
                buffer.append(' ');
            }
            this.toStringName(buffer, flags);
        }
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        this.toStringName(buffer, 0);
    }

    protected void toStringName(StringBuffer buffer, int flags) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            int i = 0;
            while (i < length) {
                try {
                    if (i < length - 1) {
                        buffer.append(parameters[i]);
                        buffer.append(", ");
                    } else {
                        buffer.append(parameters[i]);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    buffer.append("*** invalid signature: ");
                    buffer.append(parameters[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.m_parameterTypes.length) {
            buff.append(delimiter);
            this.escapeMementoName(buff, this.m_parameterTypes[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    public int getNumberOfParameters() {
        return this.m_parameterTypes == null ? 0 : this.m_parameterTypes.length;
    }

    @Override
    public String[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    @Override
    public IModelElement getPrimaryElement(boolean checkOwner) {
        SourceModule cu;
        if (checkOwner && (cu = (SourceModule)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IModelElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IJSType)primaryParent).getMethod(this.name, this.m_parameterTypes);
    }

    @Override
    public String getReturnType() throws ModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return new String(info.getReturnTypeName());
    }

    @Override
    public boolean isConstructor() throws ModelException {
        if (!this.getElementName().equals("constructs")) {
            return false;
        }
        JSSourceMethodElementInfo info = (JSSourceMethodElementInfo)this.getElementInfo();
        return info.isConstructor();
    }

    public SourceField getLocalDeclaration(String name, String type) {
        return new VjoLocalVariable(this, name, 0, 0, 0, 0, type);
    }
}

