/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElementDeltaBuilder;
import org.eclipse.dltk.mod.internal.core.ModelOperation;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.internal.core.util.Util;

public class CommitWorkingCopyOperation
extends ModelOperation {
    public CommitWorkingCopyOperation(ISourceModule element, boolean force) {
        super(new IModelElement[]{element}, force);
    }

    @Override
    protected void executeOperation() throws ModelException {
        try {
            this.beginTask(Messages.workingCopy_commit, 2);
            SourceModule workingCopy = this.getSourceModule();
            if (" ".equals(workingCopy.getScriptProject().getElementName())) {
                workingCopy.getBuffer().save(this.progressMonitor, this.force);
                return;
            }
            ISourceModule primary = workingCopy.getPrimary();
            boolean isPrimary = workingCopy.isPrimary();
            ModelElementDeltaBuilder deltaBuilder = null;
            ProjectFragment root = (ProjectFragment)workingCopy.getAncestor(3);
            boolean isIncluded = !Util.isExcluded(workingCopy);
            IFile resource = (IFile)workingCopy.getResource();
            if (isPrimary || root.validateOnBuildpath().isOK() && isIncluded && resource.isAccessible() && Util.isValidSourceModule((IModelElement)workingCopy, workingCopy.getResource())) {
                if (!isPrimary && !primary.isOpen()) {
                    primary.open(null);
                }
                if (!(!isIncluded || isPrimary && workingCopy.isConsistent())) {
                    deltaBuilder = new ModelElementDeltaBuilder(primary);
                }
                IBuffer primaryBuffer = primary.getBuffer();
                if (!isPrimary) {
                    if (primaryBuffer == null) {
                        return;
                    }
                    char[] primaryContents = primaryBuffer.getCharacters();
                    boolean hasSaved = false;
                    try {
                        IBuffer workingCopyBuffer = workingCopy.getBuffer();
                        if (workingCopyBuffer == null) {
                            return;
                        }
                        primaryBuffer.setContents(workingCopyBuffer.getCharacters());
                        primaryBuffer.save(this.progressMonitor, this.force);
                        primary.makeConsistent(this);
                        hasSaved = true;
                    }
                    finally {
                        if (!hasSaved) {
                            primaryBuffer.setContents(primaryContents);
                        }
                    }
                } else {
                    primaryBuffer.save(this.progressMonitor, this.force);
                    primary.makeConsistent(this);
                }
            } else {
                String encoding = null;
                try {
                    encoding = resource.getCharset();
                }
                catch (CoreException coreException) {}
                String contents = workingCopy.getSource();
                if (contents == null) {
                    return;
                }
                try {
                    byte[] bytes = encoding == null ? contents.getBytes() : contents.getBytes(encoding);
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    if (resource.exists()) {
                        resource.setContents((InputStream)stream, this.force ? 3 : 2, null);
                    } else {
                        resource.create((InputStream)stream, this.force, this.progressMonitor);
                    }
                }
                catch (CoreException e) {
                    throw new ModelException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ModelException(e, 985);
                }
            }
            this.setAttribute("hasModifiedResource", "true");
            workingCopy.updateTimeStamp((SourceModule)primary);
            workingCopy.makeConsistent(this);
            this.worked(1);
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null) {
                    this.addDelta(deltaBuilder.delta);
                }
            }
            this.worked(1);
        }
        finally {
            this.done();
        }
    }

    protected SourceModule getSourceModule() {
        return (SourceModule)this.getElementToProcess();
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getElementToProcess().getResource();
        if (resource == null) {
            return null;
        }
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    @Override
    public IModelStatus verify() {
        SourceModule cu = this.getSourceModule();
        if (!cu.isWorkingCopy()) {
            return new ModelStatus(967, cu);
        }
        if (cu.hasResourceChanged() && !this.force) {
            return new ModelStatus(981);
        }
        return ModelStatus.VERIFIED_OK;
    }
}

