/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.compiler.task;

import org.eclipse.dltk.mod.ast.ASTNode;
import org.eclipse.dltk.mod.ast.ASTVisitor;
import org.eclipse.dltk.mod.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.mod.ast.expressions.Literal;
import org.eclipse.dltk.mod.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.mod.compiler.task.TodoTaskRangeParser;
import org.eclipse.dltk.mod.core.DLTKCore;

public class TodoTaskAstParser
extends TodoTaskRangeParser {
    public TodoTaskAstParser(ITodoTaskPreferences preferences) {
        super(preferences);
    }

    public void initialize(ModuleDeclaration ast) {
        this.resetRanges();
        if (ast != null) {
            this.setCheckRanges(true);
            ASTVisitor visitor = new ASTVisitor(){

                @Override
                public boolean visitGeneral(ASTNode node) throws Exception {
                    if (TodoTaskAstParser.this.isSimpleNode(node)) {
                        TodoTaskAstParser.this.excludeRange(node.sourceStart(), node.sourceEnd());
                    }
                    return true;
                }
            };
            try {
                ast.traverse(visitor);
            }
            catch (Exception e) {
                DLTKCore.error("Unexpected error", e);
            }
        } else {
            this.setCheckRanges(true);
        }
    }

    protected boolean isSimpleNode(ASTNode node) {
        return node instanceof Literal;
    }
}

