/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ast.expressions;

import org.eclipse.dltk.mod.ast.expressions.Literal;
import org.eclipse.dltk.mod.utils.CorePrinter;

public class FloatNumericLiteral
extends Literal {
    private double doubleValue;

    public FloatNumericLiteral(int start, int end, double value) {
        super(start, end);
        this.doubleValue = value;
    }

    public FloatNumericLiteral(int start, int end, String value) {
        super(start, end);
        this.doubleValue = Double.parseDouble(value);
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public String getValue() {
        return String.valueOf(this.doubleValue);
    }

    @Override
    public int getKind() {
        return 1055;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrintLn(this.getValue());
    }
}

