/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.util.INodeEmitter;
import org.eclipse.vjet.dsf.html.dom.util.IRawSaxHandler;
import org.eclipse.vjet.dsf.html.dom.util.ISelfRender;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class DProcessingInstruction
extends DNode
implements ProcessingInstruction,
ISelfRender {
    private static final long serialVersionUID = 3644273682180788756L;
    private String m_target;

    public DProcessingInstruction(DDocument document, String target) {
        this(document, target, null);
    }

    public DProcessingInstruction(DDocument document, String target, String data) {
        super(document);
        this.m_target = target;
        this.m_nodeValue = data;
    }

    @Override
    public boolean render(IRawSaxHandler rawSaxHandler, IXmlStreamWriter xmlStreamWriter, INodeEmitter nodeEmitter) {
        xmlStreamWriter.writeRaw("<?");
        xmlStreamWriter.writeRaw(this.getTarget());
        xmlStreamWriter.writeRaw(" ");
        String data = this.getData() == null ? "" : this.getData();
        xmlStreamWriter.writeRaw(data);
        xmlStreamWriter.writeRaw("?>");
        return true;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(16, "ProcessingInstruction does not support having children");
    }

    @Override
    public String getTarget() {
        return this.m_target;
    }

    @Override
    public String getData() {
        return this.m_nodeValue;
    }

    public DProcessingInstruction setDsfData(String data) throws DOMException {
        this.setData(data);
        return this;
    }

    @Override
    public void setData(String data) throws DOMException {
        this.m_nodeValue = data;
    }

    @Override
    public final short getNodeType() {
        return 7;
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public DProcessingInstruction jif(String jif) {
        super.jif(jif);
        return this;
    }

    @Override
    public String toString() {
        Z z = new Z();
        z.format("target", (Object)this.m_target);
        z.format("data", (Object)this.m_nodeValue);
        return z.toString();
    }
}

