/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Entity;

public class DEntityInternal
extends DNode
implements Entity {
    private static final long serialVersionUID = 4066512827364288302L;
    private boolean m_parameterEntity = false;
    private String m_replacementText;
    private String m_xmlEncoding;
    private String m_inputEncoding;
    private String m_xmlVersion;

    public DEntityInternal(DDocument doc, String name) {
        super(doc, name);
    }

    public DEntityInternal(DDocument doc, String name, String replacementText) {
        this(doc, name);
        this.setReplacementText(replacementText);
    }

    @Override
    public final short getNodeType() {
        return 6;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public String getNotationName() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return this.m_inputEncoding;
    }

    @Override
    public String getXmlEncoding() {
        return this.m_xmlEncoding;
    }

    @Override
    public String getXmlVersion() {
        return this.m_xmlVersion;
    }

    public String getReplacementText() {
        return this.m_replacementText;
    }

    public void setReplacementText(String text) {
        if (text == null || text.trim().equals("")) {
            throw new DsfRuntimeException("Replacement text must not be null or empty");
        }
        this.m_replacementText = text;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        if (xmlVersion == null || DDocument.XML_VERSIONS.indexOf(xmlVersion) == -1) {
            throw new DOMException(9, "unknown xml version " + xmlVersion);
        }
        this.m_xmlVersion = xmlVersion;
    }

    public void setXmlEncoding(String value) {
        if (value == null || DDocument.ENCODEINGS.indexOf(value.toLowerCase()) == -1) {
            throw new DOMException(9, "unsupported XmlEncoding " + value);
        }
        this.m_xmlEncoding = value;
    }

    public void setInputEncoding(String value) {
        if (value == null || DDocument.ENCODEINGS.indexOf(value.toLowerCase()) == -1) {
            throw new DOMException(9, "unsupported InputEncoding " + value);
        }
        this.m_inputEncoding = value;
    }

    public boolean isParameterEntity() {
        return this.m_parameterEntity;
    }

    public void setParameterEntry(boolean value) {
        this.m_parameterEntity = value;
    }

    @Override
    public String toString() {
        StringWriter out = new StringWriter(100);
        this.write(out);
        return out.toString();
    }

    public void write(Writer out) {
        try {
            out.write("<!ENTITY ");
            if (this.isParameterEntity()) {
                out.write("% ");
            }
            out.write(this.getNodeName());
            out.write(" ");
            out.write(this.escapeText(this.m_replacementText));
            out.write(">");
        }
        catch (IOException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    private String escapeText(String text) {
        return "'" + text + "'";
    }
}

