/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.statistics;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.vjet.dsf.common.statistics.DarwinStatisticsCtx;
import org.eclipse.vjet.dsf.common.statistics.IV4Statistics;
import org.eclipse.vjet.dsf.dom.DCDATASection;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.util.XmlWriterHelper;

public abstract class BaseHistogram
implements IV4Statistics {
    private Map<String, DarwinStatisticsPageView> m_histo = new ConcurrentHashMap<String, DarwinStatisticsPageView>();

    @Override
    public void reset() {
        this.m_histo.clear();
    }

    @Override
    public String asString() {
        return XmlWriterHelper.asString(this.toXml());
    }

    public void count(String pageViewId, String cmpId, long usage, long ref) {
        DarwinStatisticsPageView pv = this.m_histo.get(pageViewId);
        if (pv == null) {
            pv = new DarwinStatisticsPageView(pageViewId);
            this.m_histo.put(pageViewId, pv);
        }
        pv.count(cmpId, usage, ref);
    }

    @Override
    public abstract String getName();

    abstract String getHistogramName();

    abstract String getSubObjName();

    @Override
    public DElement toXml() {
        DElement cmpHisto = new DElement(this.getHistogramName());
        TreeMap<String, DarwinStatisticsPageView> sortedMap = new TreeMap<String, DarwinStatisticsPageView>(this.m_histo);
        for (Map.Entry entry : sortedMap.entrySet()) {
            DarwinStatisticsPageView pvObj = (DarwinStatisticsPageView)entry.getValue();
            DElement pageViewTag = new DElement("page-view");
            DElement pageViewGuidTag = new DElement("guid");
            pageViewGuidTag.add(new DCDATASection(pvObj.getPageViewName()));
            pageViewTag.add(pageViewGuidTag);
            Map<String, DarwinStatisticsUnit> objMap = pvObj.getDarwinStatisticsUnitMap();
            TreeMap<String, DarwinStatisticsUnit> sortedObjMap = new TreeMap<String, DarwinStatisticsUnit>(objMap);
            for (Map.Entry objEntry : sortedObjMap.entrySet()) {
                DarwinStatisticsUnit obj = (DarwinStatisticsUnit)objEntry.getValue();
                DElement cmpTag = new DElement(this.getSubObjName());
                DElement cmpGuidTag = new DElement("guid");
                cmpGuidTag.add(new DCDATASection(obj.getGuid()));
                cmpTag.add(cmpGuidTag);
                DElement cmpCountTag = new DElement("count");
                cmpTag.add(cmpCountTag);
                DElement cmpUsageTag = new DElement("usage");
                cmpUsageTag.add(new DCDATASection(String.valueOf(obj.getCount().getUsage())));
                cmpCountTag.add(cmpUsageTag);
                DElement cmpRefTag = new DElement("ref");
                cmpRefTag.add(new DCDATASection(String.valueOf(obj.getCount().getRef())));
                cmpCountTag.add(cmpRefTag);
                pageViewTag.add(cmpTag);
            }
            cmpHisto.add(pageViewTag);
        }
        return cmpHisto;
    }

    public static class DarwinStatisticsPageView {
        private String m_pvId;
        private Map<String, DarwinStatisticsUnit> m_darwinStatisticsUnitMap;

        public DarwinStatisticsPageView(String pvId) {
            this.m_pvId = pvId;
            this.m_darwinStatisticsUnitMap = new ConcurrentHashMap<String, DarwinStatisticsUnit>();
        }

        public DarwinStatisticsPageView(String pvId, String guid) {
            this(pvId);
            this.m_darwinStatisticsUnitMap.put(guid, new DarwinStatisticsUnit(guid));
        }

        public void count(String cmpId, long usage, long ref) {
            DarwinStatisticsUnit v4Obj = this.m_darwinStatisticsUnitMap.get(cmpId);
            if (v4Obj == null) {
                v4Obj = new DarwinStatisticsUnit(cmpId);
                this.m_darwinStatisticsUnitMap.put(cmpId, v4Obj);
            }
            DarwinStatisticsCtx.DarwinStatisticsCount count = v4Obj.getCount();
            count.incrementUsage(usage);
            count.incrementRef(ref);
        }

        public final Map<String, DarwinStatisticsUnit> getDarwinStatisticsUnitMap() {
            return this.m_darwinStatisticsUnitMap;
        }

        String getPageViewName() {
            return this.m_pvId;
        }

        void setPageViewName(String pvId) {
            this.m_pvId = pvId;
        }
    }

    public static class DarwinStatisticsUnit {
        private String m_guid;
        private DarwinStatisticsCtx.DarwinStatisticsCount m_count;

        DarwinStatisticsUnit(String guid) {
            this(guid, 1L);
        }

        DarwinStatisticsUnit(String guid, long x) {
            this.m_guid = guid;
            this.m_count = new DarwinStatisticsCtx.DarwinStatisticsCount();
        }

        public String getGuid() {
            return this.m_guid;
        }

        public void setGuid(String guid) {
            this.m_guid = guid;
        }

        public DarwinStatisticsCtx.DarwinStatisticsCount getCount() {
            return this.m_count;
        }
    }
}

