/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.container.DsfNodeContainer;
import org.eclipse.vjet.dsf.common.context.DefaultDsfNodeEventQueue;
import org.eclipse.vjet.dsf.common.context.Direction;
import org.eclipse.vjet.dsf.common.context.IConverterRegistry;
import org.eclipse.vjet.dsf.common.context.IDsfAppCtx;
import org.eclipse.vjet.dsf.common.context.IDsfNodeEventQueue;
import org.eclipse.vjet.dsf.common.context.IResettableSubCtx;
import org.eclipse.vjet.dsf.common.context.ISubCtx;
import org.eclipse.vjet.dsf.common.context.IdGenerator;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.phase.PhaseDriver;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.util.DeferConstructionCollector;

public class DsfCtx {
    private static ThreadLocalContext s_context = new ThreadLocalContext();
    private IDsfAppCtx m_appCtx;
    private DNode m_rootNode;
    private IConverterRegistry m_converterRegistry;
    private IDsfNodeEventQueue m_nodeEventQueue;
    private DsfNodeContainer m_container;
    private PhaseDriver m_lifecycle;
    private boolean m_isSecureRequest = false;
    private Direction m_direction = Direction.UNDEFINED;
    private Map<String, ISubCtx> m_subContextHolder;
    private IdGenerator m_idGenerator = new IdGenerator();
    private DeferConstructionCollector m_deferConstructionCollector = new DeferConstructionCollector();
    private String m_userAgent;
    private boolean m_resourceDebug;

    public static DsfCtx ctx() {
        return (DsfCtx)s_context.get();
    }

    public static void setCtx(DsfCtx context) {
        s_context.set(context);
    }

    public static DsfCtx createCtx() {
        DsfCtx context = DsfCtx.ctx();
        if (context == null) {
            context = new DsfCtx();
            s_context.set(context);
        } else {
            context.reset();
        }
        return context;
    }

    private DsfCtx() {
    }

    public DsfCtx(DNode componentRoot) {
        s_context.set(this);
        this.m_rootNode = componentRoot;
    }

    public DsfCtx(IDsfAppCtx appCtx) {
        s_context.set(this);
        this.m_appCtx = appCtx;
    }

    public IdGenerator ids() {
        return this.m_idGenerator;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public DsfCtx setUserAgent(String userAgent) {
        this.m_userAgent = userAgent;
        return this;
    }

    public void setResourceDebugEnabled(boolean value) {
        this.m_resourceDebug = value;
    }

    public boolean isResourceDebugEnabled() {
        return this.m_resourceDebug;
    }

    public boolean isSecureRequest() {
        return this.m_isSecureRequest;
    }

    public DsfCtx setRequestSecure(boolean isSecure) {
        this.m_isSecureRequest = isSecure;
        return this;
    }

    public DsfCtx reset() {
        this.m_rootNode = null;
        this.m_appCtx = null;
        this.m_converterRegistry = null;
        this.m_nodeEventQueue = null;
        this.m_lifecycle = null;
        this.m_container = null;
        this.m_direction = Direction.UNDEFINED;
        this.m_isSecureRequest = false;
        if (this.m_subContextHolder != null) {
            this.resetSubCtx(this.m_subContextHolder.values());
        }
        this.m_subContextHolder = null;
        this.m_idGenerator.resetAllIds();
        this.m_deferConstructionCollector.reset();
        return this;
    }

    private void resetSubCtx(Collection<ISubCtx> values) {
        for (ISubCtx ctx : values) {
            if (!(ctx instanceof IResettableSubCtx)) continue;
            ((IResettableSubCtx)ctx).reset();
        }
    }

    public DsfCtx setCompRoot(DNode rootNode) {
        return this.setRootNode(rootNode);
    }

    public DsfCtx setRootNode(DNode rootNode) {
        this.m_rootNode = rootNode;
        return this;
    }

    public DNode getRootNode() {
        return this.m_rootNode;
    }

    public DNode getCompRoot() {
        return this.getRootNode();
    }

    public PhaseDriver getLifecycle() {
        return this.getPhaseDriver();
    }

    public PhaseDriver getPhaseDriver() {
        if (this.m_lifecycle == null) {
            this.m_lifecycle = new PhaseDriver();
        }
        return this.m_lifecycle;
    }

    public DsfNodeContainer getContainer() {
        if (this.m_container == null) {
            this.m_container = new DsfNodeContainer();
            this.m_container.addNodeInstantiationValidator(this.getDeferConstructionCollector());
        }
        return this.m_container;
    }

    public IDsfAppCtx getAppCtx() {
        return this.m_appCtx;
    }

    public DsfCtx setAppCtx(IDsfAppCtx appCtx) {
        this.m_appCtx = appCtx;
        return this;
    }

    public DsfCtx setConverterRegistry(IConverterRegistry converterRegistry) {
        if (converterRegistry == null) {
            throw new RuntimeException("converterRegistry is null");
        }
        this.m_converterRegistry = converterRegistry;
        return this;
    }

    public IConverterRegistry getConverterRegistry() {
        return this.m_converterRegistry;
    }

    public IDsfNodeEventQueue getNodeEventQueue() {
        if (this.m_nodeEventQueue == null) {
            this.m_nodeEventQueue = new DefaultDsfNodeEventQueue(this);
        }
        return this.m_nodeEventQueue;
    }

    public Direction getDirection() {
        return this.m_direction;
    }

    void setComponentEventQueue(IDsfNodeEventQueue queue) {
        this.m_nodeEventQueue = queue;
    }

    void setLifecycle(PhaseDriver lifecycle) {
        this.m_lifecycle = lifecycle;
    }

    public DsfCtx setContainer(DsfNodeContainer container) {
        this.m_container = container;
        return this;
    }

    public DsfCtx setDirection(Direction direction) {
        this.m_direction = direction;
        return this;
    }

    ISubCtx getSubCtx(String name) {
        return this.getSubContextHolder().get(name);
    }

    void setSubCtx(String name, ISubCtx ctx) {
        if (ctx == null) {
            this.removeSubCtx(name);
            return;
        }
        this.getSubContextHolder().put(name, ctx);
    }

    void removeSubCtx(String name) {
        this.getSubContextHolder().remove(name);
    }

    private Map<String, ISubCtx> getSubContextHolder() {
        if (this.m_subContextHolder == null) {
            this.m_subContextHolder = new HashMap<String, ISubCtx>(5);
        }
        return this.m_subContextHolder;
    }

    public DeferConstructionCollector getDeferConstructionCollector() {
        return this.m_deferConstructionCollector;
    }

    void setDeferConstructionCollector(DeferConstructionCollector collector) {
        this.m_deferConstructionCollector = collector;
    }

    public DsfCtx createChildCtx() {
        DsfCtx childContext = new DsfCtx();
        childContext.m_isSecureRequest = this.m_isSecureRequest;
        if (this.m_subContextHolder != null) {
            childContext.m_subContextHolder = new HashMap<String, ISubCtx>(this.m_subContextHolder.size());
            for (String key : this.m_subContextHolder.keySet()) {
                ISubCtx subCtx = this.getSubCtx(key);
                if (!(subCtx instanceof IInheritable)) continue;
                childContext.m_subContextHolder.put(key, ((IInheritable)((Object)subCtx)).inherit());
            }
        }
        return childContext;
    }

    /* synthetic */ DsfCtx(DsfCtx dsfCtx) {
        this();
    }

    public static interface IInheritable {
        public ISubCtx inherit();
    }

    private static class ThreadLocalContext
    extends InheritableThreadLocal<DsfCtx> {
        private ThreadLocalContext() {
        }

        @Override
        protected DsfCtx initialValue() {
            return new DsfCtx(null);
        }

        @Override
        protected DsfCtx childValue(DsfCtx parentContext) {
            DsfCtx childContext = new DsfCtx(null);
            childContext.m_container = parentContext.m_container;
            childContext.m_rootNode = parentContext.m_rootNode;
            childContext.m_nodeEventQueue = parentContext.m_nodeEventQueue;
            childContext.m_converterRegistry = parentContext.m_converterRegistry;
            childContext.m_isSecureRequest = parentContext.m_isSecureRequest;
            childContext.m_appCtx = parentContext.m_appCtx;
            childContext.m_lifecycle = parentContext.m_lifecycle;
            childContext.m_direction = parentContext.m_direction;
            Map parentSubContextHolder = parentContext.m_subContextHolder;
            if (parentSubContextHolder != null) {
                childContext.m_subContextHolder = new HashMap(parentSubContextHolder.size());
                for (Map.Entry entry : parentSubContextHolder.entrySet()) {
                    ISubCtx value = (ISubCtx)entry.getValue();
                    if (value == null) {
                        DsfExceptionHelper.chuck((String)("SubContext " + (String)entry.getKey() + " should not be null"));
                        continue;
                    }
                    if (!(value instanceof IInheritable)) continue;
                    childContext.m_subContextHolder.put((String)entry.getKey(), value.cloneCtx());
                }
            }
            return childContext;
        }
    }
}

