/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.binding;

import org.eclipse.vjet.dsf.common.binding.BaseValueBinding;
import org.eclipse.vjet.dsf.common.binding.IBeanValueBinding;
import org.eclipse.vjet.dsf.common.binding.PropertyHelper;

public class BeanValueBinding<Target, T>
extends BaseValueBinding<T>
implements IBeanValueBinding<Target, T> {
    private static final long serialVersionUID = 1L;
    private Target m_target;
    private String m_propertyName;

    public BeanValueBinding(Target target, String propertyNameKey, Class<T> valueType) {
        super(valueType);
        this.setTarget(target);
        this.setPropertyName(propertyNameKey);
    }

    @Override
    public void setTarget(Target target) {
        this.assertNotNull(target, "Bean target must not be null");
        this.m_target = target;
    }

    @Override
    public Target getTarget() {
        return this.m_target;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.assertNotNull(propertyName, "Bean property name must not be null");
        this.m_propertyName = propertyName;
    }

    @Override
    public String getPropertyName() {
        return this.m_propertyName;
    }

    @Override
    public void setValue(T value) {
        this.assertState();
        PropertyHelper.put(this.getTarget(), this.getPropertyName(), value);
    }

    @Override
    public T getValue() {
        this.assertState();
        return (T)PropertyHelper.get(this.getTarget(), this.getPropertyName());
    }

    protected final void assertState() {
        if (this.m_target == null) {
            this.chuck("Bean target must not be null");
        }
        if (this.m_propertyName == null) {
            this.chuck("Property name must not be null");
        }
    }

    public String toString() {
        return String.valueOf(this.m_propertyName) + " on: {" + this.m_target + "}";
    }
}

