/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.StringUtils;
import org.eclipse.vjet.dsf.js.dbgp.ISourceProvider;
import org.eclipse.vjet.dsf.js.dbgp.PathUtil;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;

public class SourceProvider
implements ISourceProvider {
    private static final char CHAR_NEW_LINE = '\n';
    private Map<String, String> m_fileMapping = new HashMap<String, String>();
    private static Logger logger = Logger.getInstance(SourceProvider.class);
    private static final int B_UF_SIZE = 1024;

    public void addFile(String filePath) {
        this.m_fileMapping.put(filePath, PathUtil.normalize(filePath));
    }

    public boolean containsFile(String filePath) {
        return this.m_fileMapping.get(filePath) != null;
    }

    @Override
    public String getSource(String filePath, int beginLine, int endLine) {
        if (filePath == null) {
            throw new IllegalArgumentException("File path shouldn't be null.");
        }
        URI fileURI = URI.create(filePath);
        try {
            return this.getContents(this.resolveURI(fileURI), beginLine, endLine);
        }
        catch (Exception e) {
            logger.log(LogLevel.ERROR, e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String[] list() {
        return new HashSet<String>(this.m_fileMapping.values()).toArray(new String[0]);
    }

    protected String getContents(String contents, int beginLine, int endLine) {
        StringBuilder builder;
        block6: {
            List lines;
            block7: {
                block5: {
                    if (contents == null || contents.length() == 0) {
                        return "";
                    }
                    if (beginLine == -1 && endLine == -1) {
                        return contents;
                    }
                    lines = StringUtils.splitStr((String)contents, (char)'\n');
                    int lineLength = lines.size();
                    endLine = endLine > lineLength + 1 ? -1 : endLine;
                    builder = new StringBuilder();
                    if (beginLine == -1 || endLine != -1) break block5;
                    int i = beginLine - 1;
                    while (i < lineLength) {
                        this.appendLine(builder, (String)lines.get(i));
                        ++i;
                    }
                    break block6;
                }
                if (beginLine != -1 || endLine == -1) break block7;
                int len = endLine - 1;
                int i = 0;
                while (i < len) {
                    this.appendLine(builder, (String)lines.get(i));
                    ++i;
                }
                break block6;
            }
            if (beginLine == -1 || endLine == -1) break block6;
            int len = endLine - 1;
            int i = beginLine - 1;
            while (i < len) {
                this.appendLine(builder, (String)lines.get(i));
                ++i;
            }
        }
        return builder.toString();
    }

    private StringBuilder appendLine(StringBuilder builder, String line) {
        return builder.append(line).append('\n');
    }

    private String resolveURI(URI uri) throws Exception {
        StringBuilder b = new StringBuilder();
        InputStream is = null;
        try {
            URL url = uri.toURL();
            is = new BufferedInputStream(url.openStream());
            byte[] cache = new byte[1024];
            int count = 0;
            while ((count = is.read(cache)) > 0) {
                b.append(new String(cache, "UTF-8"), 0, count);
            }
        }
        finally {
            is.close();
        }
        return b.toString();
    }
}

