/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstSynthesizedProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVjoBaseProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstVjoProperty;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.meta.JsType;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.CompletionsFilteredRobustTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ICompletionsFilter;
import org.eclipse.vjet.dsf.jstojava.translator.robust.IntegerHolder;

public class TypeRobustTranslator
extends CompletionsFilteredRobustTranslator
implements ICompletionsFilter {
    private static final List<String> NON_REPEATABLE_KEYWORDS_LIST = new ArrayList<String>();

    static {
        NON_REPEATABLE_KEYWORDS_LIST.add("props");
        NON_REPEATABLE_KEYWORDS_LIST.add("protos");
        NON_REPEATABLE_KEYWORDS_LIST.add("endType");
    }

    @Override
    public String[] filter(String[] completions) {
        return this.excludeCompletions(completions);
    }

    private String[] excludeCompletions(String[] completions) {
        completions = this.excludeRepetition(completions);
        completions = this.excludeProcessedSingletons(completions);
        return completions;
    }

    private String[] excludeProcessedSingletons(String[] completions) {
        ArrayList<String> filtered = new ArrayList<String>();
        String[] stringArray = completions;
        int n = completions.length;
        int n2 = 0;
        while (n2 < n) {
            boolean valuesProcessed;
            String completion = stringArray[n2];
            boolean inheritsProcessed = completion.equals("inherits") && this.jst.getExtend() != null;
            boolean finalProcessed = completion.equals("makeFinal") && this.jst.getModifiers().isFinal();
            boolean bl = valuesProcessed = completion.equals("values") && this.jst.isEnum() || !completion.equals("values");
            if (!inheritsProcessed && !finalProcessed && valuesProcessed) {
                filtered.add(completion);
            }
            ++n2;
        }
        return filtered.toArray(new String[0]);
    }

    private String[] excludeRepetition(String[] completions) {
        IExpression receiver = null;
        ArrayList<String> filtered = new ArrayList<String>();
        filtered.addAll(Arrays.asList(completions));
        for (IProgramElement item : this.astElements) {
            if (item instanceof FieldReference) {
                receiver = ((FieldReference)item).getReceiver();
            }
            if (!(item instanceof MessageSend)) continue;
            receiver = (MessageSend)item;
            while (receiver != null && receiver instanceof MessageSend) {
                String token = TranslateHelper.getStringToken((IProgramElement)receiver);
                if (filtered.contains(token) && NON_REPEATABLE_KEYWORDS_LIST.contains(token)) {
                    filtered.remove(token);
                    ALLOWED_KEYWORDS.add(token);
                }
                receiver = ((MessageSend)receiver).getReceiver();
            }
        }
        return filtered.toArray(new String[0]);
    }

    public TypeRobustTranslator(TranslateCtx ctx) {
        super(ctx);
        this.filter = this;
    }

    protected void transformType() {
        this.weakTranslator.getProvider().getTypeTranslator().processCType((MessageSend)this.current, this.jst);
        this.weakTranslator.getCtx().setCurrentType(this.jst);
    }

    @Override
    public boolean transform() {
        List<IJsCommentMeta> metaArr;
        IProgramElement ne;
        if (this.astElements.size() > 0) {
            this.current = (IProgramElement)this.astElements.pop();
        }
        this.transformType();
        TranslateCtx ctx = this.weakTranslator.getCtx();
        if (!(this.current instanceof MessageSend)) {
            return false;
        }
        int next = ((MessageSend)this.current).sourceEnd;
        if (this.astElements.size() > 0 && (ne = (IProgramElement)this.astElements.peek()) instanceof MessageSend) {
            char[] selector = ((MessageSend)ne).selector;
            String src = ctx.getOriginalSourceAsString();
            if (selector != null && src != null) {
                next = src.indexOf(String.valueOf(selector), next);
            }
        }
        if ((metaArr = ctx.getCommentCollector().getCommentMeta(this.current.sourceStart(), ctx.getPreviousNodeSourceEnd(), next)) != null) {
            if (metaArr.size() > 0) {
                IJsCommentMeta iJsCommentMeta = metaArr.get(0);
                ctx.getCurrentType().addCommentLocation(iJsCommentMeta.getBeginOffset(), iJsCommentMeta.getEndOffset(), true);
            }
            JstModifiers modifiers = ctx.getCurrentType().getModifiers();
            for (IJsCommentMeta meta : metaArr) {
                JsType jsType;
                JstModifiers mods = meta.getModifiers();
                if (mods.isAbstract()) {
                    modifiers.setAbstract();
                }
                if (mods.isFinal()) {
                    modifiers.setFinal();
                }
                if (mods.isPublic()) {
                    modifiers.setPublic();
                }
                if (mods.isPrivate()) {
                    modifiers.setPrivate();
                }
                if (mods.isProtected()) {
                    modifiers.setProtected();
                }
                if (mods.isDynamic()) {
                    modifiers.setDynamic();
                }
                if (!(meta.getTyping() instanceof JsType) || (jsType = (JsType)meta.getTyping()).getArgs().size() <= 0) continue;
                TranslateHelper.addParamsToType(ctx, ctx.getCurrentType(), jsType);
            }
        }
        this.addVjoSynthesizedMembers(ctx.getCurrentType());
        this.lookupEmptyCompletion();
        return super.transform();
    }

    private void addVjoSynthesizedMembers(JstType currentType) {
        boolean isInstanceInner;
        if (currentType.isOType()) {
            return;
        }
        boolean bl = isInstanceInner = currentType.isEmbededType() && !currentType.getModifiers().isStatic();
        if (!isInstanceInner) {
            JstVjoProperty staticVj = new JstVjoProperty("vj$", (IJstType)currentType);
            staticVj.getModifiers().setPrivate().setStatic(true).setFinal();
            staticVj.setParent((IJstNode)currentType);
            currentType.addProperty((IJstProperty)staticVj);
        }
        if (!currentType.isInterface()) {
            JstVjoProperty instanceVj = new JstVjoProperty("vj$", (IJstType)currentType, true);
            instanceVj.getModifiers().setPrivate().setStatic(false).setFinal();
            instanceVj.setParent((IJstNode)currentType);
            currentType.addProperty((IJstProperty)instanceVj);
            if (currentType.isClass()) {
                JstVjoBaseProperty baseProp = new JstVjoBaseProperty("base", (IJstType)currentType);
                baseProp.getModifiers().setPrivate().setStatic(false).setFinal();
                baseProp.setParent((IJstNode)currentType);
                currentType.addProperty((IJstProperty)baseProp);
            }
        } else {
            JstSynthesizedProperty clazzProp = new JstSynthesizedProperty((IJstType)JstCache.getInstance().getType("vjo.Class"), "clazz", null, null);
            clazzProp.getModifiers().setPublic().setFinal().setStatic(true);
            clazzProp.setParent((IJstNode)currentType);
            currentType.addProperty((IJstProperty)clazzProp);
        }
    }

    public static IntegerHolder getIntegerHolder(int i) {
        return new IntegerHolder(i);
    }
}

