/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.launchConfigurations;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.debug.ui.launchConfigurations.IMainLaunchConfigurationTabListener;
import org.eclipse.dltk.mod.debug.ui.launchConfigurations.IMainLaunchConfigurationTabListenerManager;
import org.eclipse.dltk.mod.debug.ui.launchConfigurations.ScriptLaunchConfigurationTab;
import org.eclipse.dltk.mod.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.mod.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.mod.launching.ScriptLaunchConfigurationConstants;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.preferences.FieldValidators;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.dltk.mod.utils.PlatformFileUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class MainLaunchConfigurationTab
extends ScriptLaunchConfigurationTab
implements IMainLaunchConfigurationTabListenerManager {
    private Text fScriptText;
    private Button interactiveConsoleCheck;
    private boolean useInteractiveConsoleGroup = false;
    ListenerList listeners = new ListenerList();
    private Button fSearchButton;
    protected static final String FIELD_SCRIPT = "mainScript";
    private Button debugConsole;

    public MainLaunchConfigurationTab(String mode) {
        super(mode);
    }

    @Override
    public void addListener(IMainLaunchConfigurationTabListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IMainLaunchConfigurationTabListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyProjectChangedListeners(IProject project) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IMainLaunchConfigurationTabListener)list[i]).projectChanged(project);
            ++i;
        }
    }

    private void notifyInteractiveChangedListeners(boolean value) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IMainLaunchConfigurationTabListener)list[i]).interactiveChanged(value);
            ++i;
        }
    }

    protected void enableInteractiveConsoleGroup() {
        this.useInteractiveConsoleGroup = true;
    }

    @Override
    protected void doInitializeForm(ILaunchConfiguration config) {
        this.updateMainModuleFromConfig(config);
        this.initializeDebugConsole(config);
        this.initializeInteractiveConsoleFrom(config);
    }

    private void initializeDebugConsole(ILaunchConfiguration config) {
        if (this.debugConsole != null) {
            this.debugConsole.setSelection(LaunchConfigurationUtils.getBoolean((ILaunchConfiguration)config, (String)ScriptLaunchConfigurationConstants.ATTR_DEBUG_CONSOLE, (boolean)true));
        }
    }

    protected void initializeInteractiveConsoleFrom(ILaunchConfiguration config) {
        if (this.useInteractiveConsoleGroup) {
            boolean console = LaunchConfigurationUtils.getBoolean((ILaunchConfiguration)config, (String)"use_dltk_interactive_console", (boolean)false);
            this.interactiveConsoleCheck.setSelection(console);
        }
    }

    protected void createMainModuleEditor(Composite parent, String text) {
        Composite editParent;
        if (this.needGroupForField(FIELD_SCRIPT)) {
            Group mainGroup = new Group(parent, 0);
            mainGroup.setText(text);
            GridData gd = new GridData(768);
            mainGroup.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            mainGroup.setLayout((Layout)layout);
            editParent = mainGroup;
        } else {
            this.createLabelForField(parent, FIELD_SCRIPT, text);
            editParent = parent;
        }
        this.fScriptText = new Text(editParent, 2052);
        GridData gd = new GridData(768);
        ScriptLaunchConfigurationTab.WidgetListener listener = this.getWidgetListener();
        this.fScriptText.setLayoutData((Object)gd);
        this.fScriptText.addModifyListener((ModifyListener)listener);
        this.fSearchButton = this.createPushButton(editParent, DLTKLaunchConfigurationsMessages.mainTab_searchButton, null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainLaunchConfigurationTab.this.handleSearchButtonSelected();
            }
        });
    }

    protected void setEnableScriptField(boolean enabled) {
        this.fScriptText.setEnabled(enabled);
        this.fSearchButton.setEnabled(enabled && this.getProjectName().length() > 0);
    }

    protected void handleSearchButtonSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(DLTKLaunchConfigurationsMessages.mainTab_searchButton_title);
        dialog.setMessage(DLTKLaunchConfigurationsMessages.mainTab_searchButton_message);
        IScriptProject proj = this.getProject();
        if (proj == null) {
            return;
        }
        dialog.setInput((Object)proj.getProject());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getProjectRelativePath().toPortableString();
            this.fScriptText.setText(arg);
        }
    }

    protected void updateMainModuleFromConfig(ILaunchConfiguration config) {
        this.fScriptText.setText(this.getMainModuleName(config));
    }

    @Override
    protected void doCreateControl(Composite composite) {
        this.createMainModuleEditor(composite, DLTKLaunchConfigurationsMessages.mainTab_mainModule);
    }

    @Override
    protected void createDebugOptions(Composite group) {
        super.createDebugOptions(group);
        if (this.canSelectDebugConsoleType()) {
            this.debugConsole = SWTFactory.createCheckButton((Composite)group, (String)"Debug console redirection");
            this.debugConsole.addSelectionListener((SelectionListener)this.getWidgetListener());
        }
    }

    protected boolean canSelectDebugConsoleType() {
        return false;
    }

    public String getName() {
        return DLTKLaunchConfigurationsMessages.mainTab_title;
    }

    @Override
    protected void setDefaults(ILaunchConfigurationWorkingCopy configuration, IModelElement element) {
        super.setDefaults(configuration, element);
        if (element instanceof ISourceModule) {
            configuration.setAttribute(FIELD_SCRIPT, element.getResource().getProjectRelativePath().toString());
        }
        this.setDefaultsDebugConsole(configuration, element);
    }

    private void setDefaultsDebugConsole(ILaunchConfigurationWorkingCopy configuration, IModelElement element) {
        if (this.debugConsole != null) {
            this.debugConsole.setSelection(true);
        }
    }

    @Override
    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(FIELD_SCRIPT, this.getScriptName());
        if (this.debugConsole != null) {
            config.setAttribute(ScriptLaunchConfigurationConstants.ATTR_DEBUG_CONSOLE, this.debugConsole.getSelection());
        }
        this.performApplyConnectionTimeout(config);
        this.performApplyInteractiveConsole(config);
    }

    protected void performApplyConnectionTimeout(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("dbpg_waiting_timeout", null);
    }

    @Override
    protected IResource getResource(ILaunchConfiguration config) throws CoreException {
        IFile scriptFile;
        String scriptName;
        String projectName = LaunchConfigurationUtils.getProjectName((ILaunchConfiguration)config);
        if (projectName == null) {
            return null;
        }
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        if (project.exists() && project.isOpen() && (scriptName = config.getAttribute(FIELD_SCRIPT, null)) != null && (scriptFile = project.getFile(scriptName)).exists()) {
            return scriptFile;
        }
        return project;
    }

    protected void performApplyInteractiveConsole(ILaunchConfigurationWorkingCopy config) {
        if (this.useInteractiveConsoleGroup) {
            String old;
            block4: {
                config.setAttribute("use_dltk_interactive_console", this.interactiveConsoleCheck.getSelection());
                old = null;
                try {
                    old = config.getAttribute("console_id", null);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            if (old == null) {
                config.setAttribute("console_id", "dltk_" + System.currentTimeMillis());
            }
        }
    }

    protected String getScriptName() {
        return this.fScriptText.getText().trim();
    }

    protected void setScriptName(String value) {
        this.fScriptText.setText(value);
    }

    protected boolean validateScript() {
        FieldValidators.FilePathValidator validator;
        IStatus result;
        URI script = this.validateAndGetScriptPath();
        IScriptProject project = this.getProject();
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
        if (script != null && !(result = (validator = new FieldValidators.FilePathValidator()).validate(script.getPath(), environment)).isOK()) {
            IFileHandle file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)environment, (IPath)Path.fromPortableString((String)script.getPath()));
            if (file.exists() && file.isDirectory()) {
                if (this.useInteractiveConsoleGroup) {
                    if (!this.interactiveConsoleCheck.getSelection()) {
                        this.setErrorMessage(DLTKLaunchConfigurationsMessages.MainLaunchConfigurationTab_0);
                        return false;
                    }
                    return true;
                }
                this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_scriptNotFound);
                return false;
            }
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_scriptNotFound);
            return false;
        }
        return true;
    }

    protected final URI validatAndGetScriptPath() {
        return this.validateAndGetScriptPath();
    }

    protected ISourceModule getSourceModule() {
        IScriptProject project = this.getProject();
        if (project == null) {
            return null;
        }
        String scriptName = this.getScriptName();
        if (scriptName.length() == 0) {
            return null;
        }
        IFile file = project.getProject().getFile(scriptName);
        return (ISourceModule)DLTKCore.create((IFile)file);
    }

    protected URI validateAndGetScriptPath() {
        URI script;
        block7: {
            String projectName = this.getProjectName();
            IScriptProject proj = this.getScriptModel().getScriptProject(projectName);
            if (proj == null) {
                return null;
            }
            this.notifyProjectChangedListeners(proj.getProject());
            URI location = proj.getProject().getLocationURI();
            if (location == null) {
                this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_notAValidProject);
                return null;
            }
            script = null;
            try {
                script = new URI(location.getScheme(), location.getHost(), String.valueOf(location.getPath()) + '/' + this.getScriptName(), location.getFragment());
            }
            catch (URISyntaxException e) {
                if (!DLTKCore.DEBUG) break block7;
                e.printStackTrace();
            }
        }
        if (script != null) {
            IFile[] files = this.getWorkspaceRoot().findFilesForLocationURI(script);
            if (files.length != 1) {
                return script;
            }
            IFile file = files[0];
            if (file.exists() && file.getLocationURI() != null) {
                script = file.getLocationURI();
            }
        }
        return script;
    }

    @Override
    protected boolean validate() {
        return super.validate() && this.validateScript();
    }

    public Image getImage() {
        return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.class_obj.gif");
    }

    private String getMainModuleName(ILaunchConfiguration config) {
        return LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)FIELD_SCRIPT, (String)"");
    }

    @Override
    protected void createCustomSections(Composite parent) {
        if (this.useInteractiveConsoleGroup) {
            Group group = new Group(parent, 0);
            group.setText(DLTKLaunchConfigurationsMessages.MainLaunchConfigurationTab_1);
            GridData gd = new GridData(768);
            group.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            this.interactiveConsoleCheck = this.createCheckButton((Composite)group, DLTKLaunchConfigurationsMessages.MainLaunchConfigurationTab_2);
            this.interactiveConsoleCheck.addSelectionListener((SelectionListener)this.getWidgetListener());
            this.interactiveConsoleCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainLaunchConfigurationTab.this.notifyInteractiveChangedListeners(MainLaunchConfigurationTab.this.interactiveConsoleCheck.getSelection());
                }
            });
        }
    }
}

