/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.completion;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jstojava.parser.comments.CommentUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;

public class JstCommentCompletion
extends JstCompletion {
    private static final char SLASH_CHAR = '/';
    private String m_commentString;
    private int m_commentOffset;
    private String m_token;

    public JstCommentCompletion(BaseJstNode parent, String commentString, int commentOffset) {
        super(parent, new String[0]);
        this.m_commentString = this.leftTrim(commentString);
        this.m_commentOffset = commentOffset;
        this.initToken();
    }

    @Override
    public String getIncompletePart() {
        String commentBeforCursor = this.getCommentBeforeCursor();
        String declarationBeforeCursor = CommentUtil.getDeclaration(commentBeforCursor);
        return declarationBeforeCursor;
    }

    public String getCommentBeforeCursor() {
        if (this.m_commentOffset < this.m_commentString.length()) {
            return this.m_commentString.substring(0, this.m_commentOffset);
        }
        return this.m_commentString;
    }

    @Override
    public String getToken() {
        return this.m_token;
    }

    private void initToken() {
        StringBuilder buffer = new StringBuilder();
        int begin = this.m_commentOffset;
        if (begin == 0) {
            this.m_token = "";
            return;
        }
        if (begin > this.m_commentString.length()) {
            this.m_token = this.m_commentString;
            return;
        }
        char ch = this.m_commentString.charAt(--begin);
        while ((Character.isJavaIdentifierPart(ch) || ch == '.' || ch == ':') && begin > 0) {
            buffer.insert(0, ch);
            ch = this.m_commentString.charAt(--begin);
        }
        if (ch == '@') {
            buffer.insert(0, ch);
        }
        this.m_token = buffer.toString();
    }

    private String leftTrim(String commentString) {
        return commentString.substring(commentString.indexOf(47));
    }
}

