/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser.comments;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.meta.ArgType;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.meta.JsAnnotation;
import org.eclipse.vjet.dsf.jst.meta.JsType;
import org.eclipse.vjet.dsf.jst.meta.JsTypingMeta;
import org.eclipse.vjet.dsf.jst.meta.Token;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsAttributed;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsFuncType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsParam;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsVariantType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.ParseException;

public class JsCommentMeta
implements IJsCommentMeta {
    IJsCommentMeta.DIRECTION m_direction;
    boolean m_cast;
    boolean m_isAnnotation;
    JsTypingMeta m_typingMeta;
    int beginOffset;
    int endOffset;
    String m_name;
    String m_commentSrc;
    List<ArgType> m_args = new ArrayList<ArgType>();
    JstModifiers m_modifiers = new JstModifiers();
    JsAnnotation m_annotation = new JsAnnotation();
    List<String> m_inactiveNeeds = new ArrayList<String>();

    public List<String> getInactiveNeeds() {
        return this.m_inactiveNeeds;
    }

    public JsAnnotation getAnnotation() {
        return this.m_annotation;
    }

    public IJsCommentMeta.DIRECTION getDirection() {
        return this.m_direction;
    }

    public boolean isCast() {
        return this.m_cast;
    }

    public boolean isAnnotation() {
        return this.m_isAnnotation;
    }

    public JstModifiers getModifiers() {
        return this.m_modifiers;
    }

    public JsTypingMeta getTyping() {
        return this.m_typingMeta;
    }

    public String getName() {
        return this.m_name;
    }

    public List<ArgType> getArgs() {
        return this.m_args;
    }

    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("//");
        if (this.m_direction.equals((Object)IJsCommentMeta.DIRECTION.BACK)) {
            sb.append(this.m_cast ? "<< " : "< ");
        } else {
            sb.append(this.m_cast ? ">> " : "> ");
        }
        sb.append(this.m_modifiers.toString().replace("[", "").replace("]", "").replace(",", " "));
        if (this.m_typingMeta instanceof JsFuncType) {
            JsFuncType funcType = (JsFuncType)this.m_typingMeta;
            sb.append(" ").append(funcType.getReturnType().getType());
            sb.append(" ").append(funcType.getFuncName());
            sb.append("(");
            boolean isF = true;
            for (JsParam itm : funcType.getParams()) {
                if (!isF) {
                    sb.append(", ");
                }
                sb.append(itm.getType()).append(" ").append(itm.getName());
                isF = false;
            }
            sb.append(")");
        } else if (this.m_typingMeta instanceof JsVariantType) {
            sb.append(" {");
            boolean isF = true;
            for (JsTypingMeta typing : ((JsVariantType)this.m_typingMeta).getTypes()) {
                if (!isF) {
                    sb.append("|");
                }
                sb.append(typing.getType());
                isF = false;
            }
            sb.append(" }");
        } else {
            sb.append(" ").append(this.m_typingMeta != null ? this.m_typingMeta.getType() : "");
        }
        return sb.toString();
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public String getCommentSrc() {
        return this.m_commentSrc;
    }

    public void setCommentSrc(String comment) {
        this.m_commentSrc = comment;
    }

    public boolean isMethod() {
        return this.m_typingMeta instanceof JsFuncType;
    }

    static void addTempleteArg(JsCommentMeta meta, JsType baseType, ArgType arg) {
        if (baseType == null && meta != null) {
            meta.m_args.add(arg);
        } else {
            baseType.addArg(arg);
        }
    }

    static void addTempleteArg(JsCommentMeta meta, JsType baseType, JsTypingMeta templateType) throws ParseException {
        if (!(templateType instanceof JsType || templateType instanceof JsAttributed || templateType instanceof JsFuncType)) {
            throw new ParseException("incorrect templete type: " + templateType.getType());
        }
        JsCommentMeta.addTempleteArg(meta, baseType, new ArgType(templateType));
    }

    static void addTempleteArg(JsCommentMeta meta, JsType baseType) throws ParseException {
        JsCommentMeta.addTempleteArg(meta, baseType, new ArgType());
    }

    static void addTempleteArg(JsCommentMeta meta, JsType baseType, JsType templeteType, ArgType.WildCardType wildcardType, JsTypingMeta boundedType) throws ParseException {
        if (!(boundedType instanceof JsType)) {
            throw new ParseException("incorrect templete bounded type: " + boundedType.getType());
        }
        JsCommentMeta.addTempleteArg(meta, baseType, new ArgType(templeteType, wildcardType, (JsType)boundedType));
    }

    static void addTempleteArg(JsCommentMeta meta, JsType baseType, ArgType.WildCardType wildcardType, JsTypingMeta boundedType) throws ParseException {
        if (!(boundedType instanceof JsType)) {
            throw new ParseException("incorrect templete bounded type: " + boundedType.getType());
        }
        JsCommentMeta.addTempleteArg(meta, baseType, new ArgType(wildcardType, (JsTypingMeta)((JsType)boundedType)));
    }

    void setDirection(boolean forward, boolean cast) {
        IJsCommentMeta.DIRECTION dIRECTION = this.m_direction = forward ? IJsCommentMeta.DIRECTION.FORWARD : IJsCommentMeta.DIRECTION.BACK;
        if (cast) {
            this.m_cast = true;
        }
    }

    void setAnnotation(String annotation) {
        this.m_isAnnotation = true;
        this.m_annotation.setAnnotation(annotation);
    }

    void setAccessModifier(Token t) throws ParseException {
        if (this.m_modifiers.isAbstract()) {
            throw new ParseException("Access control cannot be set after abstract keyword.");
        }
        if (this.m_modifiers.isStatic()) {
            throw new ParseException("Access control cannot be set after static keyword.");
        }
        this.m_modifiers.merge(JstModifiers.getFlag((String)t.image));
    }

    void setFinal() throws ParseException {
        if (this.m_modifiers.isFinal()) {
            throw new ParseException("Duplicate modifier final not allowed.");
        }
        if (this.m_modifiers.isAbstract()) {
            throw new ParseException("can be either abstract or final, not both.");
        }
        this.m_modifiers.setFinal();
    }

    void setAbstract() throws ParseException {
        if (this.m_modifiers.isAbstract()) {
            throw new ParseException("Duplicate modifier abstract not allowed.");
        }
        if (this.m_modifiers.isFinal()) {
            throw new ParseException("can be either abstract or final, not both.");
        }
        this.m_modifiers.setAbstract();
    }

    void setStatic() throws ParseException {
        if (this.m_modifiers.isStatic()) {
            throw new ParseException("Duplicate modifier static not allowed.");
        }
        this.m_modifiers.setStatic(true);
    }

    void setDynamic() throws ParseException {
        if (this.m_modifiers.isDynamic()) {
            throw new ParseException("Duplicate modifier dynamic not allowed.");
        }
        this.m_modifiers.setDynamic();
    }

    void setTyping(JsTypingMeta typingMeta) {
        this.m_typingMeta = typingMeta;
    }

    void setOptional(boolean isOptional) {
        if (isOptional) {
            this.m_typingMeta.setOptional(isOptional);
        }
    }

    void setName(String name) {
        this.m_name = name;
        if (this.m_typingMeta instanceof JsFuncType) {
            ((JsFuncType)this.m_typingMeta).setFuncName(name, null);
        }
    }

    JsCommentMeta setMethod() {
        this.m_typingMeta = new JsFuncType(this.m_typingMeta);
        return this;
    }

    void addNeedsAnnotation(Token t) {
        this.m_inactiveNeeds.add(t.image);
        this.m_isAnnotation = true;
        this.m_annotation.setAnnotation(t.toString());
    }

    void addParam(String name, JsTypingMeta typing, boolean isFinal, boolean isOptional, boolean isVariable) throws ParseException {
        ((JsFuncType)this.m_typingMeta).addParam(name, typing, isFinal, isOptional, isVariable);
    }

    void setTypeFactoryEnabled(boolean set) {
        if (this.m_typingMeta instanceof JsFuncType) {
            ((JsFuncType)this.m_typingMeta).setTypeFactoryEnabled(set);
        }
    }

    void setFuncArgMetaExtensionEnabled(boolean set) {
        if (this.m_typingMeta instanceof JsFuncType) {
            ((JsFuncType)this.m_typingMeta).setFuncArgMetaExtensionEnabled(set);
        }
    }
}

