/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.preferences;

import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.debug.ui.preferences.Filter;
import org.eclipse.dltk.mod.internal.debug.ui.ScriptDebugOptionsManager;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.preference.IPreferenceStore;

public class StepFilterManager {
    public static String[] getActiveFilters(String nature) {
        IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit((String)nature);
        return StepFilterManager.toStrings(StepFilterManager.getActiveFilters(languageToolkit.getPreferenceStore()));
    }

    public static String[] getActiveFilters(IScriptProject project) {
        try {
            IDLTKLanguageToolkit coreToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
            IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit((String)coreToolkit.getNatureId());
            return StepFilterManager.toStrings(StepFilterManager.getActiveFilters(languageToolkit.getPreferenceStore()));
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    private static String[] toStrings(Filter[] activeFilters) {
        String[] filters = new String[activeFilters.length];
        int i = 0;
        while (i < filters.length) {
            filters[i] = activeFilters[i].getName();
            ++i;
        }
        return filters;
    }

    public static Filter[] getActiveFilters(IPreferenceStore store) {
        Filter[] filters = null;
        String[] activefilters = ScriptDebugOptionsManager.parseList(store.getString("org.eclipse.dltk.mod.debug.ui.preference_active_filters_list"));
        filters = new Filter[activefilters.length];
        int i = 0;
        while (i < activefilters.length) {
            String[] split = activefilters[i].split(":");
            filters[i] = split.length == 1 ? new Filter(split[0], true, 0) : new Filter(split[0], true, new Integer(split[1]));
            ++i;
        }
        return filters;
    }

    public static boolean isUseStepFilters(IScriptProject project) {
        try {
            IDLTKLanguageToolkit coreToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
            IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit((String)coreToolkit.getNatureId());
            return StepFilterManager.isUseStepFilters(languageToolkit.getPreferenceStore());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isUseStepFilters(IPreferenceStore preferenceStore) {
        return preferenceStore.getBoolean("org.eclipse.dltk.mod.debug.useStepFilters");
    }

    public static void setUseStepFilters(boolean selection, IPreferenceStore preferenceStore) {
        preferenceStore.setValue("org.eclipse.dltk.mod.debug.useStepFilters", selection);
    }
}

