/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.display;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.dltk.mod.console.IScriptInterpreter;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugElement;
import org.eclipse.dltk.mod.debug.ui.display.DebugConsole;
import org.eclipse.dltk.mod.debug.ui.display.DebugScriptInterpreter;
import org.eclipse.dltk.mod.debug.ui.display.JDTScriptInterpreterAdapter;
import org.eclipse.dltk.mod.debug.ui.display.Messages;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.ViewPart;

public class ScriptDisplayView
extends ViewPart
implements IConsoleView,
ISelectionListener,
IDebugEventSetListener {
    private DebugConsole console;
    private PageSite pageSite;
    private IPageBookViewPage page;
    private DebugScriptInterpreter debugScriptInterpreter;
    private JDTScriptInterpreterAdapter jdtScriptInterpreter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.debugScriptInterpreter = new DebugScriptInterpreter((IViewPart)this);
        this.jdtScriptInterpreter = new JDTScriptInterpreterAdapter();
        this.console = new DebugConsole(Messages.ScriptDisplayView_consoleName, DebugConsole.class.getName(), this.debugScriptInterpreter);
        this.page = this.console.createPage(this);
        this.pageSite = new PageSite(this.getViewSite());
        this.page.init((IPageSite)this.pageSite);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
        if (this.console != null) {
            this.console.dispose();
            this.console = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        IToolBarManager toolBarManager = this.pageSite.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new GroupMarker("outputGroup"));
        toolBarManager.add((IContributionItem)new GroupMarker("launchGroup"));
        this.page.createControl(parent);
        ((SubActionBars)this.pageSite.getActionBars()).activate();
    }

    public void setFocus() {
        this.page.setFocus();
    }

    public void display(IConsole console) {
    }

    public IConsole getConsole() {
        return this.console;
    }

    public boolean getScrollLock() {
        return false;
    }

    public boolean isPinned() {
        return false;
    }

    public void pin(IConsole console) {
    }

    public void setPinned(boolean pin) {
    }

    public void setScrollLock(boolean scrollLock) {
    }

    public void warnOfContentChange(IConsole console) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.handleSelectionChangedEvent(part, selection);
    }

    private void handleSelectionChangedEvent(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof IDebugElement)) {
            return;
        }
        this.setInterpreterByDebugElement(element);
    }

    private void setInterpreterByDebugElement(Object element) {
        Object interpreter = null;
        if (element instanceof IScriptDebugElement) {
            interpreter = this.debugScriptInterpreter;
        } else if (element instanceof IJavaThread) {
            IJavaThread javaThread = (IJavaThread)element;
            try {
                if (javaThread.isSuspended() && javaThread.hasStackFrames()) {
                    interpreter = this.jdtScriptInterpreter;
                    this.jdtScriptInterpreter.setStackFrame((IJavaStackFrame)javaThread.getStackFrames()[0]);
                }
            }
            catch (DebugException e) {
                DLTKDebugPlugin.log((Throwable)e);
            }
        } else if (element instanceof IJavaStackFrame) {
            interpreter = this.jdtScriptInterpreter;
            this.jdtScriptInterpreter.setStackFrame((IJavaStackFrame)element);
        }
        if (interpreter != null) {
            this.console.setInterpreter((IScriptInterpreter)interpreter);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            switch (events[i].getKind()) {
                case 2: {
                    switch (events[i].getDetail()) {
                        case 8: 
                        case 16: {
                            this.setInterpreterByDebugElement(events[i].getSource());
                        }
                    }
                    break;
                }
            }
            ++i;
        }
    }
}

