/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.osgicommand.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper;
import org.eclipse.virgo.shell.osgicommand.management.ClassLoadingSupportMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ClassLoadingSupport
implements ClassLoadingSupportMBean {
    private BundleContext bundleContext;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ClassLoadingSupport(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public Map<List<String>, List<String>> getBundlesContainingResource(String resourcePattern) {
        Map<Bundle, List<String>> resources = ClassLoadingHelper.getBundlesContainingResource(this.bundleContext, resourcePattern);
        HashMap<List<String>, List<String>> result = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Bundle, List<String>> entry : resources.entrySet()) {
            result.put(this.getBundleInformation(entry.getKey()), entry.getValue());
        }
        return result;
    }

    @Override
    public Map<List<String>, List<String>> getBundlesLoadingClass(String className) {
        Map<Bundle, Bundle> bundles = ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className);
        HashMap<List<String>, List<String>> result = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Bundle, Bundle> entry : bundles.entrySet()) {
            Bundle loadingBundle = entry.getKey();
            Bundle originatingBundle = entry.getKey();
            result.put(this.getBundleInformation(loadingBundle), this.getBundleInformation(originatingBundle));
        }
        return result;
    }

    @Override
    public List<List<String>> getBundlesExportingPackage(String packageName) {
        Bundle[] allBundles = this.bundleContext.getBundles();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        Bundle[] bundleArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (ClassLoadingHelper.isPackageExported(this.bundleContext, packageName, bundle)) {
                result.add(this.getBundleInformation(bundle));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean tryToLoadClassFromBundle(String className, long bundleId) {
        try {
            ClassLoadingSupport.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            Class<?> result = ClassLoadingHelper.tryToLoadClass(className, this.bundleContext.getBundle(bundleId));
            boolean bl = result != null;
            ClassLoadingSupport.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return bl;
        }
        catch (Throwable throwable) {
            ClassLoadingSupport.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private List<String> getBundleInformation(Bundle bundle) {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(bundle != null ? "" + bundle.getBundleId() : null);
        list.add(bundle != null ? bundle.getSymbolicName() : null);
        return list;
    }

    static {
        Factory factory = new Factory("ClassLoadingSupport.java", Class.forName("org.eclipse.virgo.shell.osgicommand.management.ClassLoadingSupport"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tryToLoadClassFromBundle", "org.eclipse.virgo.shell.osgicommand.management.ClassLoadingSupport", "java.lang.String:long:", "className:bundleId:", "", "boolean"), 76);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.osgicommand.management.ClassLoadingSupport");
    }
}

