/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import javax.validation.ValidatorFactory;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.bval.util.PrivilegedActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureActions
extends PrivilegedActions {
    public static PrivilegedAction<ClassLoader> getContextClassLoader() {
        return GetContextClassLoader.instance;
    }

    public static PrivilegedAction<Field> getDeclaredField(final Class<?> clazz, final String fieldName) {
        return new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field f = clazz.getDeclaredField(fieldName);
                    SecureActions.setAccessibility(f);
                    return f;
                }
                catch (NoSuchFieldException ex) {
                    return null;
                }
            }
        };
    }

    public static PrivilegedAction<Field[]> getDeclaredFields(final Class<?> clazz) {
        return new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                AccessibleObject[] fields = clazz.getDeclaredFields();
                if (fields.length > 0) {
                    AccessibleObject.setAccessible(fields, true);
                }
                return fields;
            }
        };
    }

    public static PrivilegedAction<Method[]> getDeclaredMethods(final Class<?> clazz) {
        return new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        };
    }

    public static PrivilegedAction<Method> getPublicMethod(final Class<?> clazz, final String methodName) {
        return new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getMethod(methodName, null);
                }
                catch (NoSuchMethodException ex) {
                    return null;
                }
            }
        };
    }

    private static void setAccessibility(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || Modifier.isPublic(field.getModifiers()) && Modifier.isAbstract(field.getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static PrivilegedAction<ValidatorFactory> doPrivBuildValidatorFactory(final ConfigurationImpl config) {
        return new PrivilegedAction<ValidatorFactory>(){

            @Override
            public ValidatorFactory run() {
                return config.doPrivBuildValidatorFactory();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetContextClassLoader
    implements PrivilegedAction<ClassLoader> {
        static final GetContextClassLoader instance = new GetContextClassLoader();

        private GetContextClassLoader() {
        }

        @Override
        public final ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

